/***************************************************************************
                          tower.cpp  -  The game tower
                             -------------------                                         

    version              : 0.1
    begin                : 10/09/1999
    copyright            : (C) 1999 by Henning Busacker
    email                : henning.busacker@duesseldorf.netsurf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "tower.h"
#include <kmsgbox.h>
#include "towerscore.h"
const int tower::speedincs [5]={40,30,20,15,12};
const int tower::multiplier [5]={25,50,75,100,125};

tower::tower(QWidget *parent):Kfun21View(parent){
	initMetaObject();
	setName("Tower");
	score=0;
    currentScore=0;
	SetupGame();
	gameover=false;
    deal();
	setMaxRound(2);
	setEnabled(true);
	setFocusPolicy(QWidget::StrongFocus);
	setFocus();

}

tower::~tower(){

	delete deck;
    for (int j=0;j<4;j++)
		for (int i=0;i<11;i++) {
			if (cards[j][i]) delete cards[j][i];
    }
    delete bar;
    delete timer;
	delete away;
	delete run;
	delete fini;
	delete totalscore;
	delete highestrun;
    deck=0;
}

void tower::SetupGame() {
	deck = new Deck(330,340,this);
	Card::setAddFlags(DeckType, Card::disallow);
	Card::setRemoveFlags(DeckType, Card::disallow);

	away = new cardPos(410,340,this,16);
	Card::setRemoveFlags(16,Card::disallow);
	Card::setAddFlags(16, Card::disallow);
    away->show();

// preparing Colors and font for the Buttons
	QColorGroup bcg(this->backgroundColor(),this->backgroundColor(),green,
			darkGreen, this->colorGroup().mid(),yellow,this->colorGroup().base());
	QFont f("blippo",28,QFont::Bold,false);
	QFontInfo fi(f);
	if ( strcmp(f.family(),fi.family()) == 0 ) {
		// got this font
		QTextStream cout( stdout, IO_WriteOnly );
		cout << "fine! The freefont package is installed!" << endl;
	} else {
        	QTextStream cout( stdout, IO_WriteOnly );
        	cout << "Please install the freefonts package with Blippo!" << endl
			<< "It looks much nicer!" << endl;
		f.setFamily("times"); // Times should be always awailabe
		f.setPointSize(28);
		f.setBold(true);
   	}

    run=new QLabel(this,"");
	run->setGeometry(500,340,80,20);
	run->setAlignment(AlignLeft);
	QString a;
	QTextStream b(a,IO_WriteOnly);
    b << i18n("Run: ") << 0 << '\0';
	run->setText(a);
	QPalette q(run->palette());
	q.setNormal(bcg);
	run->setPalette(q);
	run->show();

    cardsleft=new QLabel(this,"");
	cardsleft->setGeometry(240,340,80,20);
	cardsleft->setAlignment(AlignLeft);
	QString ac;
	QTextStream bc(ac,IO_WriteOnly);
    bc << i18n("Cards left: ") << 24 << '\0';
	cardsleft->setText(ac);
	QPalette qc(run->palette());
	qc.setNormal(bcg);
	cardsleft->setPalette(qc);
	cardsleft->show();

	fini = new QPushButton(i18n("Take Score!"),this);
	fini->setGeometry(500,395,160,40);
	fini->setBackgroundColor(this->backgroundColor());
	fini->setFont(f);
	QPalette qf(fini->palette());
	qf.setNormal(bcg);
	fini->setPalette(qf);
	fini->show();

	totalscore = new QLabel(this,"");
	totalscore->setGeometry(610,30,150,18);
	totalscore->setAlignment(AlignLeft);
	QPalette qt(totalscore->palette());
	qt.setNormal(bcg);
	totalscore->setPalette(qt);

//	totalscore->setFrameStyle(QFrame::Panel | QFrame::Sunken);
//	f.setPointSize(18);
//	f.setBold(false);
//	totalscore->setFont(f);
	QString aa;
	QTextStream bb(aa,IO_WriteOnly);
		bb << i18n("Total Score: ") << score << '\0';

	totalscore->setText(aa);
	totalscore->show();

	highestrun = new QLabel(this,"");
	highestrun->setGeometry(610,10,150,18);
	highestrun->setAlignment(AlignLeft);
	QPalette qh(highestrun->palette());
	qh.setNormal(bcg);
	highestrun->setPalette(qh);

//	highestrun->setFrameStyle(QFrame::Panel | QFrame::Sunken);
//	f.setPointSize(18);
//	f.setBold(false);
//	totalscore->setFont(f);
	KConfig *config = kapp->getConfig();
	config->setGroup("TOWER");
	highestRun=config->readNumEntry("HighRun",0);

	QString ar;
	QTextStream br(ar,IO_WriteOnly);
	br << i18n("High Run: ") << highestRun << '\0';

	highestrun->setText(ar);
	highestrun->show();

	connect(this,SIGNAL(signalTotalScore(int)),SLOT(showTotalScore(int)));

	int startx=3*40+10;  // Three half cards + Offset
	int starty=80;
    for (int j=0;j<4;j++) {
		for (int i=0;i<11;i++) {
			cards[j][i]=0;
			if ((i % 3) ==0 && i>0 ) {
				Card::setAddFlags(i, Card::disallow);
				Card::setRemoveFlags(i, Card::disallow);
            	cards[j][i]=new cardPos(startx + (i-3) * 80,starty,this,i); //3,6,9

            	if (j>0 ) {   // 2,5,8
					Card::setAddFlags(i-1, Card::disallow);
					Card::setRemoveFlags(i-1, Card::disallow);
					cards[j][i-1]=new cardPos(startx -80 + (i-3) * 80,starty,this,i-1);

            	}
            	if (j>1) {  // 1,4,7
					cards[j][i-2]=new cardPos(startx -160 + (i-3) * 80,starty,this,i-2);
					Card::setAddFlags(i-2, Card::disallow);
					Card::setRemoveFlags(i-2, Card::disallow);

            	}
            	if (j>2 && i==3) {
					cards[j][i-3]=new cardPos(10,starty,this,0);
					Card::setAddFlags(0, Card::disallow);
					Card::setRemoveFlags(0, Card::disallow);

            	}
			}
    	}
    	starty+=45; // half card Y-size
    	startx+=40;
    }
	bar = new ColorProgressBar(0,5000,5000,ColorProgressBar::Horizontal,this,"Bar");
	bar->setGeometry(240,15,324,24);
	bar->setBarStyle(ColorProgressBar::Blocked);
	bar->setLowRange(red,20);
	bar->setMidRange(yellow,50);
	bar->setHighRange(green);
	bar->setScaleFactor(0.4);
	bar->show();
	timer = new QTimer(this);
	connect(timer,SIGNAL(timeout()),SLOT(slotCountDown()));
    setMaximumSize(810,450);
    setMinimumSize(810,450);
}

void tower::restart() {
	Kfun21View::restart();
	score=0;
	currentScore=0;
	towersetsfinished=0;
	deal();
	setMaxRound(2);
	showTotalScore(score);
}

void tower::deal() {
	disconnect(this, SLOT(handle(int)));
//	disconnect(this, SLOT(slotTowerFinished(int)));

	deck->hide();
	deck->collectAndShuffle();
	Card* c;
	c=deck->next();
	while (c) {
		if(c->FaceUp()) c->flipCard();
		c=c->next();
    }

    bool tf=true;
    for (int j=0;j<4;j++) {
        if (j==3)tf=false;
		for (int i=3;i<11;i=i+3) {
            c=deck->getCard();
            if(!c) c=deck->getCard();

            cards[j][i]->add(c,tf,false); //3,6,9
            c->show();
			if (j==3)
 				connect( cards[j][i] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );

            if (j>0) {   // 2,5,8
                c=deck->getCard();
				cards[j][i-1]->add(c,tf,false);
                c->show();
				if (j==3)
 					connect( cards[j][i-1] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );
            }
            if (j>1) {  // 1,4,7
                c=deck->getCard();
				cards[j][i-2]->add(c,tf,false);
                c->show();
				if (j==3)
 					connect( cards[j][i-2] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );

            }
            if (j>2 && i==3) {
                c=deck->getCard();
				cards[j][i-3]->add(c,tf,false);
                c->show();
				if (j==3)
 					connect( cards[j][i-3] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );

            }

    	}
    }
	connect(deck,SIGNAL(nonMovableCardPressed(int)),SLOT(handleDeck(int)));
    deck->show();
    c=deck->getCard();
	lastValue=c->Value();
    away->add(c,false,false);
    cardsLeft=23;
	QString ac;
	QTextStream bc(ac,IO_WriteOnly);
    bc << i18n("Cards left: ") << cardsLeft << '\0';
	cardsleft->setText(ac);
	QPalette qc(run->palette());
    gameover=false;
	towerfinished=0;
	currentRun=0;
}

void tower::keyPressEvent ( QKeyEvent * e ) {
}

bool tower::handle(int pile) {
    int i= pile;
    int j,jj=4;
    for (j=3; j>=0; j--)
		if (cards[j][i]) {
			if (cards[j][i]->next()) {
				jj=j;
				break;
			}
		}
    j=jj;
   	if (!timer->isActive()) {
   		slotGameRunning();
   		bar->setRange(-speedincs[Speed()],32*speedincs[Speed()]);
   		bar->setValue(32*speedincs[Speed()]);
   		timer->start(100*speedincs[Speed()]);
		connect(fini,SIGNAL(clicked()),SLOT(slotTakeScore()));

   	}

    Card*c=cards[j][i]->top();
    if ((c->Value()==lastValue+1) || (c->Value()==lastValue-1) ||
		(c->Value()==13 && lastValue==1) ||(c->Value()==1 && lastValue==13) ) {
		cards[j][i]->unlink();
		cards[j][i]->hide();
		lastValue=c->Value();
		disconnect( cards[j][i] , SIGNAL(nonMovableCardPressed(int)),this,SLOT(handle(int)) );
		currentRun++;
		QString a;
		QTextStream b(a,IO_WriteOnly);
	    b << i18n("Run: ") << currentRun << '\0';
		run->setText(a);
		if (currentRun>highestRun){
			highestRun=currentRun;
			QString c;
			QTextStream bc(c,IO_WriteOnly);
	    	bc << i18n("High Run: ") << highestRun << '\0';
			highestrun->setText(c);
		}
        away->add(c,false,false);
		switch (currentRun ) {
			case 1: score +=100; currentScore+=100; break;
			case 2: score +=200; currentScore+=200; break;
			case 3: score +=400; currentScore+=400; break;
			case 4: score +=600; currentScore+=600; break;
			case 5: score +=800; currentScore+=800; break;
			default: score+=1000;currentScore+=1000;
		}
		showTotalScore(score);
		if (j>0) {
            if ((i<10) && (cards[j][i+1]) && !(cards[j][i+1]->next())) {
            // right neighbour
    			if(cards[j-1][i+1]) {
    				cards[j-1][i+1]->turnTop();
     				connect( cards[j-1][i+1] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );
    			}
            }
            if ((i>0) && (cards[j][i-1]) && !(cards[j][i-1]->next())) {
            // left neighbour
    			if (cards[j-1][i]) {
    				cards[j-1][i]->turnTop();
     				connect( cards[j-1][i] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );
    			}
            }
		} else {
			if (i>0) slotTowerFinished(pile);
		}
		return true;
    }
return false;

}

void tower::handleDeck(int) {
	Card* c=deck->next();
    if (c) {
		if (!timer->isActive()) {
			slotGameRunning();
			bar->setRange(-speedincs[Speed()],32*speedincs[Speed()]);
			bar->setValue(32*speedincs[Speed()]);
			timer->start(100*speedincs[Speed()]);
			connect(fini,SIGNAL(clicked()),SLOT(slotTakeScore()));

		}
		Card* c=deck->getCard();
		lastValue=c->Value();
		away->add(c,false,false);
		score-=100;
		currentScore-=100;
		currentRun=0;
		QString aa;
		QTextStream bb(aa,IO_WriteOnly);
		bb << i18n("Run: ") << currentRun << '\0';
		run->setText(aa);
        showTotalScore(score);
		cardsLeft--;
		QString ac;
		QTextStream bc(ac,IO_WriteOnly);
		bc << i18n("Cards left: ") << cardsLeft << '\0';
		cardsleft->setText(ac);
		QPalette qc(run->palette());

	}
	else  disconnect(deck,SIGNAL(nonMovableCardPressed(int)),this,SLOT(handleDeck(int)));

}

void tower::slotTakeScore() {
	gameover=true;
	timer->stop();
	disconnect(deck,SIGNAL(nonMovableCardPressed(int)),this,SLOT(handleDeck(int)));
	disconnect(fini,SIGNAL(clicked()),this,SLOT(slotTakeScore()));

	KConfig *config = kapp->getConfig();
	config->setGroup("TOWER");
	config->writeEntry("HighRun",highestRun);
	QString a;
	QTextStream b(a,IO_WriteOnly);
	int bonus=bar->value()*multiplier[Speed()]/30;
    score=score+bonus+cardsLeft*1000;
	showTotalScore(score);
    currentScore=currentScore+bonus+cardsLeft*1000;
	b << i18n("Bonus : ") << multiplier[Speed()] <<" * "<< bar->value()/30 << "=" << bonus << endl
	  << i18n("Score : ") << currentScore << endl
	  << i18n("Points: ") << score << endl << '\0';
	QString comment;
    if(towersetsfinished==2) comment=i18n("Bonus Round");
	else comment = (Round()==2? i18n("May be next time"):i18n("Bonus Round at 70000"));
	if (Round()==3) comment="";
	TowerScore towerscore(a,comment,this,"socre");
	towerscore.exec();
//		KMsgBox::message(this,"Fun21",a,KMsgBox::EXCLAMATION);
	
    clearFocus();
	slotFinished("Tower",currentScore);
	bar->setRange(-speedincs[Speed()],32*speedincs[Speed()]);
	bar->setValue(32*speedincs[Speed()]);
	currentScore=0;
    setFocus();
	
}

void tower::slotCountDown() {
	if (bar->value() >=0)  {
		bar->setValue(bar->value()-speedincs[Speed()]);
	} else {
		bar->setValue(bar->value()-speedincs[Speed()]);
		timer->stop();
		KMsgBox::message(this,i18n("Sorry"),i18n("Timeout!"),KMsgBox::EXCLAMATION);
		slotTakeScore();
	}
}

QStrList* tower::levelNames() {
	if (!levelnames) {
		levelnames=new QStrList();
		levelnames->append(i18n("Slow"));
		levelnames->append(i18n("Normal"));
 		levelnames->append(i18n("Fast"));
		levelnames->append(i18n("Insane"));
 		levelnames->append(i18n("Tonik"));
	}
	return levelnames;
}

void tower::showTotalScore(int _score) {
		QString a;
		QTextStream b(a,IO_WriteOnly);
		b << i18n("Total Score: ") << _score << '\0';
		totalscore->setText(a);

}

void tower::slotTowerFinished(int pile){
   	towerfinished++;
   	if (towerfinished==1) { score+= 5000; currentScore+= 5000;}
   	if (towerfinished==2) { score+=10000; currentScore+=10000;}
   	if (towerfinished==3) { score+=15000; currentScore+=15000;}
   	QString a;
   	QTextStream b(a,IO_WriteOnly);
   	b << i18n("Total Score: ") << score << '\0';
   	totalscore->setText(a);
   	if (towerfinished==3) {
		towersetsfinished++;
		if (towersetsfinished==2) setMaxRound(3);
   		slotTakeScore();
	}
}
















