/***************************************************************************
                          tower.h  -  the game Tower
                             -------------------                                         

    version              : 0.1
    begin                : 10/09/1999
    copyright            : (C) 1999 by Henning Busacker
    email                : henning.busacker@duesseldorf.netsurf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TOWER_H
#define TOWER_H

#include <kfun21view.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include "patience.h"
#include "colorprogressbar.h"

/**This the game Tower against the clock
  *@author Henning Busacker
  */

class tower : public Kfun21View  {
  Q_OBJECT
public:
	tower(QWidget *parent=0);
	virtual ~tower();
/** return a list of levelnames */
	virtual QStrList* levelNames();
public slots: // Public slots
/** restart game */
	virtual void restart();
signals:
/** signalFinished(const char* game, const int points) */
	void signalFinished(const char *,const int);

protected slots:
	virtual void showTotalScore(int);

protected:
/** mixes the cards and deals them */
	virtual void deal();
	virtual void keyPressEvent ( QKeyEvent * e );

private slots:
  /** Handler for a card on the towers */
	bool handle(int pile);
  /** Handles the face down card stack */
	void handleDeck(int);
  /** takes the current score and keeps track of new games and rounds */
	void slotTakeScore();
  /** called by the timer. Handles the Progressbar and the timeout */
	void slotCountDown();
  /** called, when a single Tower is finished. Takes care of the Bonus points,taking the score and enabling
a bonus game. */
  void slotTowerFinished(int);

private:
/** sets up the playfield and the labels and buttons */
	void SetupGame();
/** shows and hides the bonus label */


  	cardPos*	cards[4][11];
/** Overall Highest Run COunt */
  	QLabel*		highestrun;
/** current Score */
  	QLabel*		totalscore;
/** Current Run Count */
  	QLabel*		run;
/** Cards left on the stack */
  	QLabel*		cardsleft;
/** Take Score Button */
  	QPushButton*	fini;
/** The time bar */
	ColorProgressBar* bar;
/** the used timer */
	QTimer*         timer;
/** holds the skipd card */
  	cardPos*		away;
/** marks the round as over */
  	bool		gameover;
	int		barinc;
/** the overall highest run count. saved in the initfile */
	int highestRun;
/** current run count. set in handle() and reset in deal() and handleDeck() */
    int currentRun;
/** the current score */
    int score; int currentScore;
/** value of last card drawn */
	int lastValue;
/** Cards left on the Stack */
	int cardsLeft;
	const static int speedincs [5];
	const static int multiplier [5];
  /** number of finished towers */
  int towerfinished;
  /** number of finished games with 3 towers for a bonus game */
  int towersetsfinished;
/*	const static int multiplier[9];
  */
};

#endif



















