/* go_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef DUMMY_PLAYER_H
#define DUMMY_PLAYER_H

#include <qobject.h>
#include <qsignal.h>
#include "go_player.h"

class KGoBoard ;

/**
 * This is KDummyPlayer: a class to fake a KGoPlayer. It can be used
 * to implement a player without extending KGoPlayer (which isn't 
 * always possible because the Qt-widget set cannot handle 
 * multiple inheritance). The class implements all virtual slots
 * and connects them to corresponding signals.
 *
 * @short A implementation of KGoPlayer  
 **/
class KDummyPlayer : public KGoPlayer
{
	Q_OBJECT

public:
	KDummyPlayer( bool color, KGoBoard *b, QWidget *parent=0,
		const char *name = 0 );
 	~KDummyPlayer();

public slots:
	void playMove( int, int ) ;
	void boardSetup() ;
	void opponentMoved(int,int) ;
	void illegalMove( int r, int p ) ;
signals:
	void notifyBoardSetup() ;
	void notifyOpponentMoved(int,int) ;
	void notifyIllegalMove( int r, int p ) ;
} ;

#endif
