

#include "includes.h"

#include "go.h"
#include "kgo.moc"
#include "kgo_widget.h"
#include "go_view.h"
#include "go_board.h"
#include "go_player.h"
#include "dialog.h"

KApplication *kgo ;

#define MENU_NEW 2
#define MENU_SAVE 3
#define MENU_LOAD 4
#define MENU_QUIT 5

#define OPT_TOGGLE_MOVE_LIST 2
#define OPT_TOGGLE_LEGENDA 5
#define OPT_TOGGLE_STATUSBAR 4
#define OPT_LEGENDA 3 

/* ##########################
 * #	class KGo           #
 * ##########################
 */

void KGo::createMenu()
{
	int id ;

	file = new QPopupMenu();
	id = file->insertItem(klocale->translate("&New game"),
				main_widget, SLOT(newgame()) );
	accel->changeMenuAccel(file, id, KAccel::New );

	id = file->insertItem( klocale->translate("&Save game"),
				MENU_SAVE ) ;
	file->connectItem( MENU_SAVE, main_widget, SLOT(saveGame()) );
	accel->changeMenuAccel(file, id, KAccel::Save );

	id = file->insertItem(klocale->translate("&Load game"),
				main_widget, SLOT(loadGame()) );
	accel->changeMenuAccel(file, id, KAccel::Open );
	
	file->insertSeparator(-1);
	id = file->insertItem(klocale->translate("&Quit"),
				this, SLOT(quitapp()) );
	accel->changeMenuAccel(file, id, KAccel::Quit );

	options = new QPopupMenu();
	id = options->insertItem( "", OPT_TOGGLE_STATUSBAR ) ;
	options->connectItem( OPT_TOGGLE_STATUSBAR,
			this, SLOT(toggleStatusBar()) ) ;
	accel->changeMenuAccel(file, id, "Toggle statusbar" );
	id = options->insertItem("", OPT_TOGGLE_LEGENDA ) ;
	options->connectItem( OPT_TOGGLE_LEGENDA,
			this, SLOT(toggleLegenda()) ) ;
	accel->changeMenuAccel(file, id, "Toggle legenda" );
	id = options->insertItem("", OPT_TOGGLE_MOVE_LIST ) ;
	options->connectItem( OPT_TOGGLE_MOVE_LIST,
			this, SLOT(toggleMovesList()) ) ;
 	id = options->insertItem(	klocale->translate("Count score"),
				this, SLOT( notImpl()) ) ;
	id = options->insertItem(	klocale->translate("&Configure keys"),
				 this, SLOT(configKeys()) );

	help = kapp->getHelpMenu( true, about() ) ;

	menu = new KMenuBar(this, "menu");
	menu->insertItem(klocale->translate("&File"), file, 5);
	menu->insertItem(klocale->translate("&Options"), options);
	menu->insertSeparator(-1);
	menu->insertItem(klocale->translate("&Help"), help);

	setMenu(menu);
}

void KGo::createStatusBar()
{
	statusbar = new KStatusBar( this ) ;

	statusbar->insertItem( klocale->translate("Pieces: 000, 000"),
			ID_PIECES ) ;
 	statusbar->insertItem( klocale->translate
			("Captured: 000, 000"),
			ID_CAPTURED ) ;    
	statusbar->insertItem( klocale->translate("Time: 0000, 0000"),
			ID_TIME ) ;
	statusbar->insertItem( klocale->translate("White to move"),
			ID_PLAYER ) ;

	statusbar->setInsertOrder(KStatusBar::LeftToRight);

	setStatusBar( statusbar ) ;
	status_slot(0) ;
}

void KGo::toggleStatusBar()
{
	if ( use_statusbar )
		use_statusbar=0 ;
	else use_statusbar=1 ;
 
	status_slot(0) ;
	menu_slot(0) ;
}

void KGo::toggleMovesList()
{
	main_widget->toggleMovesList() ;
	menu_slot( 0 ) ;
}

void KGo::toggleLegenda()
{
	main_widget->toggleLegenda() ;
	menu_slot( 0 ) ;
}

void KGo::menu_slot(int)
{
	if ( main_widget->saveAbleGame() )
		file->setItemEnabled( MENU_SAVE, true ) ;
	else	file->setItemEnabled( MENU_SAVE, false ) ;

	if( statusBar()->isVisible() )
	{
		options->changeItem( 
			klocale->translate("Disable StatusBar"),
			OPT_TOGGLE_STATUSBAR ) ;
	}
	else
	{
		options->changeItem(
 			klocale->translate("Enable StatusBar"),
			OPT_TOGGLE_STATUSBAR ) ;
	}

	if( main_widget->legenda() )
	{
		options->changeItem( 
			klocale->translate("Disable legenda"),
			OPT_TOGGLE_LEGENDA ) ;
	}
	else
	{
		options->changeItem(
 			klocale->translate("Enable legenda"),
			OPT_TOGGLE_LEGENDA ) ;
	}

	if( main_widget->movesList() )
	{
		options->changeItem( 
			klocale->translate("Disable moves list"),
			OPT_TOGGLE_MOVE_LIST ) ;
	}
	else
	{
		options->changeItem(
 			klocale->translate("Enable moves list"),
			OPT_TOGGLE_MOVE_LIST ) ;
	}
}
 
void KGo::status_slot(int)
{
	if ( use_statusbar )
		enableStatusBar( KStatusBar::Show ) ;
	else	enableStatusBar( KStatusBar::Hide ) ;

	QString tmp ;
	
	KGoBoard *b = main_widget->getGoBoard() ;
	if ( b!=0 )
	{
		tmp.sprintf( klocale->translate("Pieces: %d, %d"), 
			b->whitePieces(),
			b->blackPieces() ) ;
		statusbar->changeItem( tmp, ID_PIECES ) ;
		tmp.sprintf( klocale->translate("Captured: %d, %d"), 
			b->whiteCaptured(),
			b->blackCaptured() ) ;
		statusbar->changeItem( tmp, ID_CAPTURED ) ;
		tmp.sprintf( klocale->translate("Time: %d, %d"), 
			b->getWhiteTime(),
			b->getBlackTime() ) ;
		statusbar->changeItem( tmp, ID_TIME ) ;

		int p = b->playerToMove() ;

		switch(p)
		{
			case WHITE:
				tmp = i18n("White to move") ;
				break ;
 			case BLACK:
				tmp = i18n("Black to move") ;
				break ;
 			case NO_PLAYER:
				tmp = i18n("Game has ended") ;
				break ;
 			default:
				tmp = i18n(
					"Internal error: unknown game state"
					) ;
 				break ;
		}
	}  
 	statusbar->changeItem( tmp, ID_PLAYER ) ;
}

void KGo::helpmenu()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}

void KGo::configKeys()
{
	KKeyDialog::configureKeys( accel ) ;
}


void KGo::createKeys()
{
	accel = new KAccel(this) ;

	// here we create to shortcuts according to
	// the standard kde keybindings
	accel->connectItem(KAccel::New, main_widget, SLOT( newgame() ) );
	accel->connectItem(KAccel::Open, main_widget, SLOT( loadGame() ) );
	accel->connectItem(KAccel::Save, main_widget, SLOT( saveGame() ) );
	accel->connectItem(KAccel::Quit, this, SLOT( quitapp() ) );

	accel->insertItem( i18n("Toggle statusbar"),
			"toggle statusbar", "CTRL+S");
	accel->connectItem( "toggle statusbar", this,
		SLOT(toggleStatusBar() ) );

	accel->readSettings( config ) ;

}


const char* KGo::about()
{
	QString *tmp = new QString() ;
	tmp->sprintf( "%s %s %s\n", NAME, VERSION, DATE ) ;
	tmp->append( klocale->translate(
		"\nA program written in C++ using Qt/Kde.\n"
		"Based on original code from the program gnugo.\n\n"
		"Written by Pieter Eendebak <pte@ddsw.nl>" )
		) ;

	return tmp->data() ;
}


void KGo::notImpl()
{
	KMsgBox::message(this, CAPTION,
	klocale->translate("Sorry, this function hasn't been implemented yet...")  );
}

void KGo::loadconfig()
{
	config = kapp->getConfig();

	main_widget->loadconfig( config ) ;

	config->setGroup( FILE_KGO ) ;
	use_statusbar = config->readNumEntry("Statusbar", 1) ;
}

void KGo::saveconfig()
{
	main_widget->saveconfig( config ) ;
	config->setGroup( FILE_KGO ) ;
	config->writeEntry("Statusbar", use_statusbar ) ;

	// Save key-bindings
	accel->writeSettings(config);
	// Save config
	config->sync();
}

void KGo::quitapp()
{
	saveconfig() ;
	main_widget->quitapp() ;
	kgo->quit() ; 
}

void KGo::paintEvent( QPaintEvent * )
{
	if( main_widget!=0 )
		main_widget->repaint() ;
}

KGo:: KGo ( QWidget *, const char* name )
	: KTopLevelWidget ( name ),
		main_widget( 0 )
{
	setCaption(CAPTION);
	resize(490, 500);

	main_widget = new KGoWidget( this, 0 ) ;

	loadconfig() ;
	createStatusBar() ;
	createKeys() ;
	createMenu() ;

	connect( main_widget, SIGNAL( boardStateChange(int)),
			this, SLOT( status_slot(int)) ) ; 
	connect( main_widget, SIGNAL( boardStateChange(int)),
			this, SLOT( menu_slot(int)) ) ; 
	setView( main_widget ) ;

	show() ;
	main_widget->newgame() ;

	menu_slot(0) ;
	status_slot(0) ;
}

KGo::~KGo()
{
	delete main_widget ;
}

/* ##########################
 * #	Main                #
 * ##########################
 */

int main(int argc, char **argv)
{
	kgo = new KApplication(argc, argv, "kgo" );
	KGo *top;
	top = new KGo(0, "kgo");
	kgo->setMainWidget(top);
	top->show();
	return kgo->exec();
}

