/* v2p_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef V2P_PLAYER_H
#define V2P_PLAYER_H

#include <qobject.h>
#include <qsignal.h>
#include <qwidget.h>

#include "go_board.h"
#include "dummy_player.h"

class KView2Player ;

class KGoBoard ;

/**
 * This is KV2P_Player. It's used to implement loading
 * and saving for the two player game.
 *
 * @short   
 **/
class KV2P_Player : public KDummyPlayer
{
	Q_OBJECT

public:
	KV2P_Player( KView2Player *v, bool color,
			KGoBoard *b, QWidget *parent=0,
			const char *name = 0 );
  	~KV2P_Player();

protected:
	int load( QDataStream &, KGoBoard * ) ;
	int save( QDataStream & ) ;

	bool canBeSaved() ;

private:
	KView2Player *view ;
} ;

#endif
