/* view_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef VIEW_PLAYER_H
#define VIEW_PLAYER_H

#include "includes.h"
#include "go_board.h"
#include "go_view.h"
#include "go_player.h"
#include "vp_player.h"


/**
 * This class is a KGoView that simulates a KGoPlayer.
 */
class KViewPlayer : public KGoView
{
	Q_OBJECT

public:
	KViewPlayer( int color, KGoBoard *b, QWidget *parent=0,
		const char *name = 0 );
 	~KViewPlayer();

	void setInformation( const char *s ) ;

public slots:
	KGoPlayer* getPlayer() ; 
	void pass() ;
	void receiveIllegalMove( int, int ) ;

	void resizeEvent( QResizeEvent * ) ;


private:
	KVP_Player *dummy ;

	QLabel *inf ;
	QPushButton *passb ;

} ;

#endif
