#ifndef KGREDIT_H 
#define KGREDIT_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qstring.h>
#include <qdir.h>
#include <qfile.h>
#include <qslider.h>
#include <qbttngrp.h>
#include <qframe.h>
#include <qlcdnum.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include "kgreditwidget.h"

class LoadLevel : public QDialog 
{
  Q_OBJECT
public:
  LoadLevel( QWidget *parent = 0, const char *name = 0 );
  virtual ~LoadLevel();
  QString getFileName();
  QString getLCD();
private:
  char *filename;
  QPushButton *ok, *cancel;
  QFrame *mainFrame,*leftFr;
  QButtonGroup *rightBG;
  QLabel *leftLabel,*rightLabel;
  QSlider *levelSlider;
  QLCDNumber *levelDigit;
  QRadioButton *system,*local;
};

class SaveLevel : public QDialog 
{
  Q_OBJECT
public:
  SaveLevel( QWidget *parent = 0, const char *name = 0 );
  virtual ~SaveLevel();
  QString getFileName();
  QString getLCD();
private:
  char *filename;
  QPushButton *ok, *cancel;
  QFrame *mainFrame,*frame;
  QLabel *label;
  QSlider *levelSlider;
  QLCDNumber *levelDigit;
};

class kgredit : public KTopLevelWidget 
{
  Q_OBJECT

 public:
  kgredit(QWidget *parent = 0, const char *name = 0);
  virtual ~kgredit();
  unsigned char getActiveObject();

 protected slots:
    void commandCallback(int id_);
    void enableSave();

 private:
  KMenuBar   *menuBar;
  KStatusBar *statusBar;
  KToolBar   *filetoolBar;
  KToolBar   *objtoolBar;
  LoadLevel  *lLevel;
  SaveLevel  *sLevel;
  bool changed;
  QString filename;
  int activeObject;
  void enableCommand(int id_);
  void disableCommand(int id_);
  void initStatusbar();
  void initToolbar();
  void initMenubar();
  void saveAs();
  int myexit();

  bool noname;
  kgreditWidget *view;
};

#endif // KGREDIT_H 
