#ifndef PLAYFIELD_H
#define PLAYFIELD_H

#include <jewel.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <highscorelist.h>

class Playfield:public QWidget{
  friend class Previewfield;
  Q_OBJECT
  public:
    Playfield(QWidget *parent, const char *name,
	      const int diff,QPushButton *,Highscorelist *, QString);
    ~Playfield();
    void paintEvent(QPaintEvent *);
    void timerEvent(QTimerEvent *);
    void keyPressed(QKeyEvent *);
    int *getNextJewel();
    Highscorelist *highscores;    
    QString kdedir;
  private:
    QWidget *mainW;
    int sizeX,sizeY;
    int score,jewels;
    int collides(int, int );
    short jewelField[8][17];
    short delList[8][17];
    Jewel *activeJewel,*nextJewel;
    QPushButton *startStop;
    int jewelTimerID;
    int blinkTimerID;
    int blinkStage,blinkHighlighted;
    void putJewel();
    void drawOneJewel(QPainter &,short ,short ,short );
    void clearOneJewel(QPainter &,short ,short ,short );
    int collectJewels();
    int collectInDirection(int, int, int ,int );
    void eraseJewels();
    int removeColor();
    void activateNextJewel();
    void levelManagment();
    void pauseGame();
    void endEffect();
    StartProcedures();
    int level,difficulty,timeSteps,colors,
        gamePaused,gameStarted,gameOver,spacePressed,noKeys;
  signals:
    void nextJewelChanged();
    void changeScore(int);
    void changeRunStatus(bool);
  public slots:
    void startPauseGame();
    void notifyDifficulty(int);
    void showList();
};

#endif
