/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "mainwidget.h"
#include <kapp.h>
#include "kmamerun_version.h"

int main( int argc, char **argv )
{
    int v;
    
    KApplication a( argc, argv );

    for (v=1; v<argc; v++){
        if (QString("-version") == argv[v]) {
            printf(KMAMERUN_VERSION);
            printf("\n");
            printf("Copyright (C) 1998 Jrgen Vigna (jug@sad.it)\n\n");
            exit(0);
        } else if (*argv[v] == '-') {
            printf(KMAMERUN_VERSION);
            printf("\n");
            printf("Copyright (C) 1998 Jrgen Vigna (jug@sad.it)\n\n");
            printf(klocale->translate("M.A.M.E frontend for the KDE Desktop Environment\n"));
            printf(klocale->translate("Permitted arguments:\n"));
            printf(klocale->translate("-help : displays this message\n"));
            printf(klocale->translate("-version : displays the version number\n"));
            printf(klocale->translate("And all KApplication and Qt-toolkit arguments.\n"));
            exit(0);
        }
    }

    MainWidget *w;
    w = argc==2 ? new MainWidget(argv[1]) : new MainWidget();
    a.setMainWidget( w );
    w->show();
    kapp->getConfig()->setGroup("kmamerun");
    return a.exec();
}
