// KDE headers
#include <kapp.h>
#include <drag.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <klocale.h>

// QT headers
#include <qwidget.h>
#include <qpushbt.h>
#include <qcolor.h>
#include <qstring.h>
#include <qstring.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qpixmap.h>
#include <qpainter.h>

// C/C++ headers
#include <time.h>
#include <iostream.h>


#define FIELD_WIDTH 30
//#define debug

class kmasterColors
{
public:
  kmasterColors(); 
  QColor* kmColor[6];
}; 

class HintField : public QWidget
{
  Q_OBJECT
public:
  int posOK;
  int colorOK;
  int moveCounter;
  HintField(QWidget* parent);
  void paintEvent(QPaintEvent* event);
  void drawHint(int p, int c);
  void setStartPosition();
};

class ChooserField : public KDNDWidget
{
  Q_OBJECT
public:
  ChooserField(QWidget* parent);
  void dndMouseMoveEvent(QMouseEvent* event);
  int colornum;
};

class DropField : public QWidget
{
  Q_OBJECT
public:
  DropField(QWidget* parent);
  int colornum;
public slots:
  void dropActionSlot(KDNDDropZone* _dropzone); 
};

class PlayGround : public QWidget
{
  Q_OBJECT
public:
  PlayGround(QWidget* parent=0, const char* name=0);
  DropField* field[4];
  void moveFields();
  void drawMove();
  void paintEvent(QPaintEvent* event);
  int moveCounter;
  QPixmap* pix;
  void setStartPosition();
};

class MainView : public QWidget
{
  Q_OBJECT
public:
  MainView(QWidget* parent);
  PlayGround* playGround;
  HintField* hintField;
  ChooserField* chooserField[6];
  int solutionField[4];
  int moveCounter;
  QPushButton* btnQuit;
  QPushButton* btnCheck;
  QPushButton* btnStart;
  QLabel* lblMove;
  void resetGame();
public slots:
  void startGame();
  void checkMove(); 
};

class MainWidget : public KTopLevelWidget
{
  Q_OBJECT
public:
  MainWidget(const char *name=0);
  QPushButton* btntest;
public slots:
};


  
