/***************************************************************************
                          ccharacterprofile.h
                          -------------------
    description          : Character Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CCHARACTERPROFILE_H
#define CCHARACTERPROFILE_H

#include <qstring.h>
#include <qdir.h>
#include <ksimpleconfig.h>

/**
  * Character Profile Class
  *@author Stephan Uhlmann
  */

struct AliasEntry
{
	QString name;
	QString definition;
	int macro;
	ButtonState modifiers;
};

struct TriggerEntry
{
	QString name;
	QString definition;
};

class CCharacterProfile {
public: 
	/** constructor */
	CCharacterProfile();
	/** destructor */
	~CCharacterProfile();


	/** returns the filename where the data are stored */
	QString getFileName();
	/** sets the filename where the data are stored */
	void setFileName(QString);

	/** reads the data of the class from its file */
	void readData();
	/** writes the data to the class to its file */
	void writeData();

	/** reads/writes aliases */
	void readAliases();
	void writeAliases();
	
	/** gets an alias */
	AliasEntry* getAlias(QString name);
		
	AliasEntry* firstAlias();
	AliasEntry* nextAlias();
	AliasEntry* currentAlias();
	
	/** Remove and add aliases */
	void insertAlias(QString name, QString def, int mac, ButtonState modifiers);
	void removeAlias(QString name);

	/** For Triggers */
	void readTriggers();
	void writeTriggers();
	TriggerEntry* getTrigger(QString);
	TriggerEntry* firstTrigger();
	TriggerEntry* nextTrigger();
	TriggerEntry* currentTrigger();
	void insertTrigger(QString name, QString def);
	void removeTrigger(QString name);	

	bool getLoggingEnabled();
	void setLoggingEnabled(bool b);
	bool getLogANSIEnabled();
	void setLogANSIEnabled(bool b);
	QString getLogFilename();
	void setLogFilename(QString filename);
	
	void setMapStartX(signed int startx);
	void setMapStartY(signed int starty);
	void setMapStartLevel(signed int start_level);
	
	signed int getMapStartX(void);
	signed int getMapStartY(void);
	signed int getMapStartLevel(void);

	
private:

	QString filename;
	QList<AliasEntry> aliases;
	QList<TriggerEntry> triggers;

	bool loggingEnabled;
	bool logANSIEnabled;
	QString logFilename;

	int currentAliasIndex;	
	int currentTriggerIndex;
	
	int map_start_x,map_start_y,map_start_level;
};

#endif
