/***************************************************************************
                          cmapelement.h
                      -------------------
    description          : Base class for map elements
    begin                : Fri Sep 8 2000
    copyright            : (C) 2000 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPELEMENT_H
#define CMAPELEMENT_H

#include <qpainter.h>
#include <qcolor.h>

#define ROOM_SIZE      20
#define HALF_ROOM_SIZE 10

enum dir { NORTH , SOUTH , WEST , EAST , NORTHWEST, NORTHEAST, SOUTHEAST , SOUTHWEST, UP, DOWN };

typedef enum dir direction;

enum element_type { ROOM, PATH, TEXT, OTHER };

typedef enum element_type elementTyp;

class CMapElement
{
public:
	CMapElement()              					{}
	virtual ~CMapElement()           				  {}
	
	void setSelected(bool sel);
	bool getSelected(void)     					{ return selected; }
	
	void setCords(int lowx,int lowy,int hix,int hiy);
	
	int getLowX(void) 						{ return startx; }
	int getLowY(void) 						{ return starty; }
	int getHiX(void) 						{ return endx; }
	int getHiY(void)  						{ return endy; }
	virtual void moveBy(int x,int y);
	virtual elementTyp getElementType(void) 			{ return OTHER; }
	
	void setLowHiX(int lowx,int hix);
	void setLowHiY(int lowy,int hiy);
	
	bool mouseInElement(int x,int y);
	bool elementIn(int x1,int y1,int x2,int y2);
	bool mouseInResize(int x,int y);
	
	virtual void paint(QPainter *p)=0;
	virtual void dragPaint(QPainter *p,int offsetx,int offsety) =0;
	virtual void lowerPaint(QPainter *p)=0;
	virtual void higherPaint(QPainter *p)=0;
	virtual CMapElement *copy(void) =0;

	void setLowerColour(QColor col)    { defaultCol = col; }
	void setHigherColour(QColor col)   { higherCol = col; }
	void setDefaultColour(QColor col)  { lowerCol = col; }
	void setSelectColour(QColor col)   { selectCol = col; }

	QColor getLowerColour(void)    { return defaultCol; }
	QColor getHigherColour(void)   { return higherCol; }
	QColor getDefaultColour(void)  { return lowerCol; }
	QColor getSelectColour(void)   { return selectCol; }

private:
	bool selected;
	
	QColor defaultCol,higherCol,lowerCol,selectCol;
	
	int startx,starty,endx,endy;


};

#endif