/***************************************************************************
                          cmudlog.cpp
                      -------------------
    description          :
    begin                : Wed Feb 16 2000
    copyright            : (C) 2000 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmudlog.h"

CMudLog::CMudLog()
{
	logFile.setName("");
}

CMudLog::~CMudLog()
{
}

bool CMudLog::open(QString filename)
{
	bool FileIsOpen=false;

	logFile.close();
	logFile.setName(filename);
	FileIsOpen=logFile.open(IO_WriteOnly | IO_Append); // only append to file

	if (!FileIsOpen)
	{
	  error(filename);
	}
	
	return FileIsOpen;
}

void CMudLog::close()
{
	logFile.close();
	logFile.setName("");
}

void CMudLog::append(QString s)
{
	if ( (logFile.name()!="") && (logFile.isOpen()) )
	{
		logFile.writeBlock(s,s.length()); // log it
		logFile.flush(); // flush (yes, I AM paranoid!)
	}
}

QString CMudLog::getLogFilename()
{
	return logFile.name();
}

void CMudLog::error(QString filename)
{
	if (filename=="")
	{
		// user enabled logging but didn't enter a filename for the log
		QMessageBox NoLogfile("Kmud",i18n("You selected no logfile."),QMessageBox::Information,
			QMessageBox::Ok | QMessageBox::Default,0,0,0,"NoLogfileMessageBox",TRUE,0);
		NoLogfile.exec();
	}
	else
	{
		// user enabled logging but the entered filename is not valid for logging
		QMessageBox NoLogfile("Kmud",filename+" "+
		  i18n("is no valid filename.\nThe path must be absolute or relative.\nDont use something like '~'."),
			QMessageBox::Information,QMessageBox::Ok | QMessageBox::Default,0,0,0,
			"NoLogfileMessageBox",TRUE,0);
		NoLogfile.exec();
	}
}
