/***************************************************************************
                          cmudprofile.cpp
                        -------------------
    description          : Mud Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cmudprofile.h"

CMudProfile::CMudProfile(){
	filename="";
	title="";
	hostname="";
	port=23;
	iType=0;
	map_directions = NULL;
	noMove = "";
	canMove = "";
	doMove = false;
}
CMudProfile::~CMudProfile(){
}

QString CMudProfile::getNoMoveStr(void)
{ return noMove; }

QString CMudProfile::getCanMoveStr(void)
{ return canMove; }

bool CMudProfile::getDoMoveCheck(void)
{ return doMove; }

void CMudProfile::setNoMoveStr(QString str)
{ noMove = str; }

void CMudProfile::setCanMoveStr(QString str)
{ canMove = str; }

void CMudProfile::setDoMoveCheck(bool set)
{ doMove = set; }

QString CMudProfile::getFileName()
{ return filename; }

void CMudProfile::setFileName(QString f)
{ filename=f; }

void CMudProfile::setFollowMode(bool follow)
{ bFollowMode = follow; }

bool CMudProfile::getFollowMode(void)
{ return bFollowMode; }

void CMudProfile::setCreateMode(bool create)
{ bCreateMode = create; }

bool CMudProfile::getCreateMode(void)
{ return bCreateMode; }

QString CMudProfile::getTitle()
{ return title; }

void CMudProfile::setTitle(QString t)
{ title=t; }

QString CMudProfile::getHostName()
{ return hostname; }

void CMudProfile::setHostName(QString h)
{ hostname=h; }

unsigned int CMudProfile::getPort()
{ return port; }

void CMudProfile::setPort(unsigned int p)
{ port=p; }

QString CMudProfile::getNamePrompt()
{ return nameprompt; }

void CMudProfile::setNamePrompt(QString n)
{ nameprompt=n; }
	
QString CMudProfile::getPasswordPrompt()
{ return passwordprompt; }

void CMudProfile::setPasswordPrompt(QString p)
{ passwordprompt=p; }

/** returns the directions */
directions *CMudProfile::getDirections()
{ return map_directions; }

/** sets the directions */
void CMudProfile::setDirections(directions *d)
{ map_directions = d; }



void CMudProfile::readData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/muds/"+filename);

	title=mudconf.readEntry("Title","");
	hostname=mudconf.readEntry("Hostname","");
	port=mudconf.readNumEntry("Port",23);
	nameprompt=mudconf.readEntry("NamePrompt","");
	passwordprompt=mudconf.readEntry("PasswordPrompt","");
	iType=mudconf.readNumEntry("InterpretType",0);
	
	map_directions = new directions;
	map_directions->north = mudconf.readEntry("North","north");
	map_directions->northeast = mudconf.readEntry("NorthEast","northeast");
	map_directions->east = mudconf.readEntry("East","east");
	map_directions->southeast = mudconf.readEntry("SouthEast","southeast");	
	map_directions->south = mudconf.readEntry("South","south");	
	map_directions->southwest = mudconf.readEntry("SouthWest","southwest");
	map_directions->west = mudconf.readEntry("West","west");
	map_directions->northwest = mudconf.readEntry("NorthWest","northwest");	
	map_directions->up = mudconf.readEntry("Up","up");
	map_directions->down = mudconf.readEntry("Down","down");
	
	noMove = mudconf.readEntry("NoMove","");
	canMove = mudconf.readEntry("CanMove","");
	doMove = mudconf.readBoolEntry("DoMove",false);

	bFollowMode = mudconf.readBoolEntry("FollowMode",false);
	bCreateMode = mudconf.readBoolEntry("CreateMode",false);
}

void CMudProfile::writeData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/muds/"+filename);

	mudconf.writeEntry("Title",title);
	mudconf.writeEntry("Hostname",hostname);
	mudconf.writeEntry("Port",port);
	mudconf.writeEntry("NamePrompt",nameprompt);
	mudconf.writeEntry("PasswordPrompt",passwordprompt);
	mudconf.writeEntry("InterpretType",iType);
	
	// BUGFIX (Kevin Krammer, 2000-07-21)
	if (map_directions == NULL) {
	  map_directions = new directions;
	}
	mudconf.writeEntry("North",map_directions->north);
	mudconf.writeEntry("NorthEast",map_directions->northeast);
	mudconf.writeEntry("East",map_directions->east);
	mudconf.writeEntry("SouthEast",map_directions->southeast);
	mudconf.writeEntry("South",map_directions->south);
	mudconf.writeEntry("SouthWest",map_directions->southwest);
	mudconf.writeEntry("West",map_directions->west);
	mudconf.writeEntry("NorthWest",map_directions->northwest);
	mudconf.writeEntry("Up",map_directions->up);
	mudconf.writeEntry("Down",map_directions->down);
	
	mudconf.writeEntry("NoMove",noMove);
	mudconf.writeEntry("CanMove",canMove);
	mudconf.writeEntry("DoMove",doMove);

	mudconf.writeEntry("FollowMode",bFollowMode);
	mudconf.writeEntry("CreateMode",bCreateMode);
}

int CMudProfile::getInterpretationType()
{
	return iType;
}

void CMudProfile::setInterpretationType(int i)
{
	iType = i;
}
