/***************************************************************************
                       cpluginmanager.h
                      -------------------
    description          :
    begin                : Mon May 15 2000
    copyright            : (C) 2000 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CPLUGINMANAGER_H
#define CPLUGINMANAGER_H

#include <qobject.h>
#include <qlist.h>
#include <qstrlist.h>

class KmudAPI;
class KmudPlugin;

/**
	* class for handling of kmud plugins
  *@author Stephan Uhlmann
  */

enum pluginstate { UNLOADED , LOADED , RUNNING };

struct PluginInfo
{
	QString filename;
	QString pathfilename;
	pluginstate state;
	void* handle;
	KmudPlugin* pointer;
};

typedef QList<PluginInfo> PluginList;

class CPluginManager : public QObject  {
	Q_OBJECT

public:

	/** constructor */
	CPluginManager(KmudAPI*);

	/** destructor */
	~CPluginManager();


	/** search for loadable KmudPlugins
		* looks for *_kmudplg.so files in the following dirs (this order):
		* $LD_LIBRARY_PATH		- for plugins coders (no need to "make install" all the time)
		* $HOME/.kde/lib/		- update plugin wihtout update of kmud
		* $KDEDIR/lib/				- normal "make install"
		*/
	void searchPlugins();

	/** load a plugin into memory */
	bool loadPlugin(QString filename);

	/** start a plugin */
	bool startPlugin(QString filename);

	/** stop a plugin */
	bool stopPlugin(QString filename);

	/** unload a plugin */
	bool unloadPlugin(QString filename);

	/** returns whether a plugin is unloaded or not */
	bool isPluginUnloaded(QString filename);

	/** returns whether a plugin is loaded or not
		* note that a running plugin is also loaded
		*/
	bool isPluginLoaded(QString filename);

	/** returns whether a plugin is running or not */
	bool isPluginRunning(QString filename);

	/** unload all plugins */
	bool unloadAllPlugins();


	/** returns a PluginInfo to the given pluginname */
	PluginInfo getPlugin(QString filename);

	/** returns a list with the PluginInfo's of all plugins found */
	PluginList getAllPlugins();

	/** returns a list with the filenames of all running plugins */
	PluginList getRunningPlugins();

private:

	/** list of the plugin */
	PluginList pluginlist;

	/** pointer to the kmud api (to give it the plugin) */
	KmudAPI* kmudapi;

};

#endif
