/***************************************************************************
                          dlgoptionecho.cpp
                         -------------------
    description          : Echo Options Dialog Class
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgoptionecho.h"

DlgOptionEcho::DlgOptionEcho(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();

	//local echo
	localEcho_ButtonGroup = new QButtonGroup(this,"localEcho_ButtonGroup");
	localEcho_ButtonGroup->insert(localEchoAuto_RadioButton);
	localEcho_ButtonGroup->insert(localEchoOn_RadioButton);
	localEcho_ButtonGroup->insert(localEchoOff_RadioButton);
	localEcho_ButtonGroup->hide();

	// input echo
	inputEcho_ButtonGroup = new QButtonGroup(this,"inputEcho_ButtonGroup");
	inputEcho_ButtonGroup->insert(inputEchoAuto_RadioButton);
	inputEcho_ButtonGroup->insert(inputEchoOn_RadioButton);
	inputEcho_ButtonGroup->insert(inputEchoOff_RadioButton);
	inputEcho_ButtonGroup->setExclusive(true);
	inputEcho_ButtonGroup->hide();


}

DlgOptionEcho::~DlgOptionEcho(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()

}

int DlgOptionEcho::getLocalEchoMode()
{
	if (localEchoOff_RadioButton->isChecked()) return 0;
	if (localEchoOn_RadioButton->isChecked()) return 1;
	return 2;
}

int DlgOptionEcho::getInputEchoMode()
{
	if (inputEchoOff_RadioButton->isChecked()) return 0;
	if (inputEchoOn_RadioButton->isChecked()) return 1;
	return 2;
}

void DlgOptionEcho::setLocalEchoMode(int i)
{
	switch (i)
	{
		case 0 : localEcho_ButtonGroup->setButton(2); break;
		case 1 : localEcho_ButtonGroup->setButton(1); break;
		default : localEcho_ButtonGroup->setButton(0);
	}
}

void DlgOptionEcho::setInputEchoMode(int i)
{
	switch (i)
	{
		case 0 : inputEcho_ButtonGroup->setButton(2); break;
		case 1 : inputEcho_ButtonGroup->setButton(1); break;
		default : inputEcho_ButtonGroup->setButton(0);
	}
}

