/***************************************************************************
                          dlgoptionfonts.cpp
                      -------------------
    description          : Font Options Dialog Class
    begin                : Fri Oct 22 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "dlgoptionfonts.h"

DlgOptionFonts::DlgOptionFonts(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Fonts"));

	initDialog();

	connect( inputFont_Button, SIGNAL(clicked()), SLOT(slotInputFontButtonPressed()) );
	connect( outputFont_Button, SIGNAL(clicked()), SLOT(slotOutputFontButtonPressed()) );

	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );

}

DlgOptionFonts::~DlgOptionFonts(){
}

void DlgOptionFonts::setOutputFont(QFont font)
{
	outputFont=font;
	QString s;
	s.setNum(font.pointSize());
	s.prepend(", ");
	s.prepend(font.family());
	outputFont_Button->setFont(font);
	outputFont_Button->setText(s);
}

void DlgOptionFonts::setInputFont(QFont font)
{
	inputFont=font;
	QString s;
	s.setNum(font.pointSize());
	s.prepend(", ");
	s.prepend(font.family());
	inputFont_Button->setFont(font);
	inputFont_Button->setText(s);
}

QFont DlgOptionFonts::getOutputFont()
{
	return outputFont;
}

QFont DlgOptionFonts::getInputFont()
{
	return inputFont;
}

void DlgOptionFonts::slotInputFontButtonPressed()
{
	KFontDialog d(this,"OutputFontDialog",true,NULL);

	d.setFont(inputFont);

	if (d.exec())
		setInputFont(d.font());
}

void DlgOptionFonts::slotOutputFontButtonPressed()
{
	KFontDialog d(this,"OutputFontDialog",true,NULL);

	d.setFont(outputFont);

	if (d.exec())
		setOutputFont(d.font());
}

