/***************************************************************************
                          dlgprofilemacros.cpp
                      -------------------
    description          : Defines Macros
    begin                : Sun Nov 14 1999
    copyright            : (C) 1999 by Luke Ehresman
    email                : luke@usa.om.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgprofilemacros.h"
#include <qmessagebox.h>
#include <X11/keysym.h>

DlgProfileMacros::DlgProfileMacros(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Macros"));

	initDialog();

	myParent = parent;
	
	connect( none_Button, SIGNAL(clicked()), SLOT(slotNone()) );	
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
}

DlgProfileMacros::~DlgProfileMacros(){
}

int DlgProfileMacros::getMacro() {
	return macro_value;
}

ButtonState DlgProfileMacros::getModifiers() {
  return key_modifiers;
}

/** When NONE is pressed */
void DlgProfileMacros::slotNone() {
	macro_value = 0;
	key_modifiers = NoButton;
	accept();
}

void DlgProfileMacros::keyPressEvent( QKeyEvent* e )
{

/*    while (tmpAlias != NULL)
    {
        if ((tmpAlias->name != alias->name) && (e->key() == tmpAlias->macro))
        {
            switch ( QMessageBox::warning(this,
                                          "ERROR",
                                          "That macro is already defined by\n \""+ tmpAlias->name +"\".  Redefine this macro?",
                                          QMessageBox::Yes,
                                          QMessageBox::No | QMessageBox::Escape ))
            {
                case QMessageBox::Yes:
                            tmpAlias->macro = 0;
                            break;
                case QMessageBox::No:
                            return;
            }
        }
        tmpAlias = profile->nextAlias();
    }
*/
	switch( e->key() ) {
//        case Key_F1:
//            QLabel_6->setText("Key: F1");
//            break;
		case Key_F2:
			macro_value = Key_F2;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F3:
			macro_value = Key_F3;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F4:
			macro_value = Key_F4;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F5:
			macro_value = Key_F5;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F6:
			macro_value = Key_F6;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F7:
			macro_value = Key_F7;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F8:
			macro_value = Key_F8;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F9:
			macro_value = Key_F9;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F10:
			macro_value = Key_F10;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F11:
			macro_value = Key_F11;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case Key_F12:
			macro_value = Key_F12;
      key_modifiers = (ButtonState) (e->state() & KeyButtonMask);
			accept();
			break;
		case XK_KP_0:
			macro_value = XK_KP_0;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_1:
			macro_value = XK_KP_1;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_2:
			macro_value = XK_KP_2;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_3:
			macro_value = XK_KP_3;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_4:
			macro_value = XK_KP_4;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_5:
			macro_value = XK_KP_5;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_6:
			macro_value = XK_KP_6;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_7:
			macro_value = XK_KP_7;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_8:
			macro_value = XK_KP_8;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_9:
			macro_value = XK_KP_9;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Equal:
			macro_value = XK_KP_Equal;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Multiply:
			macro_value = XK_KP_Multiply;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Add:
			macro_value = XK_KP_Add;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Separator:
			macro_value = XK_KP_Separator;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Subtract:
			macro_value = XK_KP_Subtract;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Decimal:
			macro_value = XK_KP_Decimal;
			key_modifiers = NoButton;
			accept ();
			break;
		case XK_KP_Divide:
			macro_value = XK_KP_Divide;
			key_modifiers = NoButton;
			accept ();
			break;
		default:
			e->ignore();
	}
	/*if (((e->key () >= Key_F2) && (e->key () <= Key_F12))
				|| ((e->key () >= XK_KP_Equal) && (e->key () <= XK_KP_9)))
		{
			macro_value = e->key ();
			accept ();
		} */ // if
}

/** catches the Keypad-Keys */
void DlgProfileMacros::slotKeypadEvent (QString keystr)
{
//	AliasEntry *tmpAlias;
	// debug ("Dialog");
//	tmpAlias = profile->firstAlias();
	if (keystr == "KP_0") macro_value = 10;
	else if (keystr == "KP_1") macro_value = 1;
	else if (keystr == "KP_2") macro_value = 2;
	else if (keystr == "KP_3") macro_value = 3;
	else if (keystr == "KP_4") macro_value = 4;
	else if (keystr == "KP_5") macro_value = 5;
	else if (keystr == "KP_6") macro_value = 6;
	else if (keystr == "KP_7") macro_value = 7;
	else if (keystr == "KP_8") macro_value = 8;
	else if (keystr == "KP_9") macro_value = 9;
	accept ();

} // slotKeypadEvent
