/***************************************************************************
                          dlgprofiletriggersinput.cpp
                      -------------------
    description          :
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "dlgprofiletriggersinput.h"


DlgProfileTriggersInput::DlgProfileTriggersInput(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Triggers"));

	initDialog();

 	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()) );

}

DlgProfileTriggersInput::~DlgProfileTriggersInput(){
}

void DlgProfileTriggersInput::slotOKPressed(){
	accept();
}

void DlgProfileTriggersInput::slotCancelPressed(){
	reject();
}

/** returns the Trigger */
QString DlgProfileTriggersInput::getTrigger ()
{
	return trigger_LineEdit->text ();
} // getTrigger

/** returns the Definition of the Trigger */
QString DlgProfileTriggersInput::getDefinition ()
{
	return definition_LineEdit->text ();
} // getDefinition

/** set's the name of the trigger */
void DlgProfileTriggersInput::setTrigger (QString Name)
{
	trigger_LineEdit->setText (Name);
} // setTrigger

/** set's the definition of the trigger */
void DlgProfileTriggersInput::setDefinition (QString Definition)
{
	definition_LineEdit->setText (Definition);
} // setDefinition
