/***************************************************************************
                          kmudview.cpp
                      -------------------
    description          : View Class (Main View)
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Stephan Uhlmann
                                       Andre Alexander Bell
    email                : suhlmann@gmx.de
                           andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmudview.h"


KmudView::KmudView(KApplication* a,KmudDoc* doc,QWidget *parent)
	: QWidget(parent){

	document = doc;
	
	///////////////////////////////////////////////////////////////////
	// setup my widgets

	output = new CMudView(document, this,"output");
	output->setFont(QFont("courier",12));
	output->setBackgroundMode(NoBackground);

	splitMode=false;
	splitoutput = new CMudView(document, this,"output");
	splitoutput->setFont(QFont("courier",12));
	splitoutput->setBackgroundMode(NoBackground);
	splitoutput->setVScrollBarVisible(false);
	splitoutput->hide();

	input = new CMudLineEdit(document, this,"input");
	input->setBackgroundMode(PaletteBackground);
	input->setFocus();
	input2 = new CMudLineEdit(document, this,"input2");
	input2->setBackgroundMode(PaletteBackground);

	setLocalEchoColor(QColor(0,0,0));

	setLocalEcho(true);
	setLocalEchoMode(2);
	setInputEcho(true);
	setInputEchoMode(2);

	//QObject::connect(input, SIGNAL(returnPressed()),SLOT(slotInputReturnPressed()));
	//QObject::connect(input2,SIGNAL(returnPressed()),SLOT(slotInput2ReturnPressed()));
	QObject::connect(input, SIGNAL(textSend(QString)), SLOT(slotInputReturnPressed(QString)));
	QObject::connect(input2, SIGNAL(textSend(QString)), SLOT(slotInputReturnPressed(QString)));
	QObject::connect(input, SIGNAL(scrollKeyPressed(QKeyEvent *)),output,SLOT(slotScrollKey(QKeyEvent *)));
	QObject::connect(input2,SIGNAL(scrollKeyPressed(QKeyEvent *)),output,SLOT(slotScrollKey(QKeyEvent *)));
	QObject::connect(input, SIGNAL(macroPressed(QString)), SLOT(slotMacroPressed(QString)));
	QObject::connect(input2,SIGNAL(macroPressed(QString)), SLOT(slotMacroPressed(QString)));
	QObject::connect(output,SIGNAL(vSliderAtBottomChanged(bool)), SLOT(slotChangeSplitMode(bool)));
}

KmudView::~KmudView(){
	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()
}


void KmudView::setOutputForegroundColor(QColor fgc)
{
	output->setForeground(fgc);
	splitoutput->setForeground(fgc);
}

QColor KmudView::getOutputForegroundColor()
{
	return output->getForeground();
}

void KmudView::setOutputBackgroundColor(QColor bgc)
{
	output->setBackground(bgc);
	splitoutput->setBackground(bgc);
}

QColor KmudView::getOutputBackgroundColor()
{
	return output->getBackground();
}


void KmudView::setOutputFont( QFont font )
{
	output->setFont(font);
	splitoutput->setFont(font);
}

QFont KmudView::getOutputFont()
{
	return output->getFont();
}

void KmudView::setInterpretType(int i)
{
	output->setInterpretType(i);
	splitoutput->setInterpretType(i);
}
int KmudView::getInterpretType()
{ 
	return output->getInterpretType(); 
}

/** for foreground colors */
void KmudView::setOutputANSIColor(int ANSIColor, QColor color)
{
  output->setOutputANSIColor(ANSIColor, color);
  splitoutput->setOutputANSIColor(ANSIColor, color);
}

QColor KmudView::getOutputANSIColor(int ANSIColor)
{
  return output->getOutputANSIColor(ANSIColor);
}

/** for background colors */
void KmudView::setOutputBgColor(int BgColor, QColor color)
{
  output->setOutputBgColor(BgColor, color);
  splitoutput->setOutputBgColor(BgColor, color);
}

QColor KmudView::getOutputBgColor(int BgColor)
{
  return output->getOutputBgColor(BgColor);
}

QColor KmudView::getDebugHighlightColor()
{
	return output->getDebugHighlightColor();
}

void KmudView::setDebugHighlightColor(QColor color)
{
	output->setDebugHighlightColor(color);
	splitoutput->setDebugHighlightColor(color);
}


void KmudView::setInputFont( QFont font )
{
	input->setFont(font);
	input2->setFont(font);
}

QFont KmudView::getInputFont()
{
	return input->font();
}

void KmudView::setInputBackgroundColor(QColor bgc)
{
// QLineEdit will only set the frame to bgc not the background itself,
// the real background will be set either to white (light bgc) or black (dark bgc)
// so to avoid a black frame on a black background set it to grey in this special case
// sorry, but dont know what QLineEdit is doing there %-|
	if (bgc==QColor(0,0,0))
		bgc=QColor(32,32,32);
	input->setPalette(QPalette(bgc));
	input2->setPalette(QPalette(bgc));
}

QColor KmudView::getInputBackgroundColor()
{
	return input->backgroundColor();
}

void KmudView::setLocalEchoColor(QColor c)
{
	localEchoColor=c;
}

QColor KmudView::getLocalEchoColor()
{
	return localEchoColor;
}

void KmudView::recalcWidgetSizes()
{
	int i=(input->fontMetrics()).height()+8;
	int splitSize=height() / 4 ;
	int scrollBarWidth=output->getVScrollBarWidth();

	if (input2->isVisible())
	{
		output->setGeometry(0,0,width(),height()-i-i);
		input->setGeometry(0,(height())-i-i,width(),i);
		input2->setGeometry(0,(height())-i,width(),i);
		i+=i;//for the splitmode later
	} else {
		output->setGeometry(0,0,width(),(height())-i);
		input->setGeometry(0,(height())-i,width(),i);
		input2->setGeometry(0,(height())-i,width(),i);
	}

	if (splitMode){
		splitoutput->show();
		splitoutput->setGeometry(0,height()-i-splitSize,width()-scrollBarWidth,splitSize);
	} else
		splitoutput->hide();

}

void KmudView::resizeEvent( QResizeEvent * )
{
	///////////////////////////////////////////////////////////////////
	// refresh Geometry settings, if view resized
	
	recalcWidgetSizes();

}

QString KmudView::displayMudOutput(QString buf)
{
	QString returnString;

	returnString = output->append(buf,output->getForeground(),output->getBackground(),output->getFont());
	splitoutput->append(buf,output->getForeground(),output->getBackground(),output->getFont());

	return returnString;
}

void KmudView::slotMacroPressed(QString macro)
{
	AliasEntry* alias;
	CCharacterProfile* prof;
	QString s = macro;
	QString tmp1, tmp2;

	prof = document->getCharacterProfile(document->getCurrentCharacterID());
	if (prof)
	{
		/** Parse semi-colons */

		alias = prof->firstAlias();
		tmp1 = s;
		s = "";

		/** bugfix to allow the enter character by itself */
		if (tmp1 == QString("")) {
			s = "\n";
		}

		/** This code parses input, replaces ; with \n, and parses
		  * aliases into their definitions.
		  */
		if (separator != "") { // Empty disables
			while (tmp1 != "") {
				if (tmp1.contains(separator)) {
					uint pos = (uint)tmp1.find(separator, 0, false);

					tmp2 = tmp1;
					tmp2.truncate(pos);
					tmp1.remove(0, pos);
					if (tmp1.find(separator, 0, true) == 0)
						tmp1.remove(0, separator.length());

					alias = prof->firstAlias();
					while (alias != NULL) {
						if (alias->name == tmp2) {
							tmp2 = alias->definition;
							if (tmp2.find(separator, 0, true) >= 0) 
								while (tmp2.find(separator, 0, true) >= 0) 
									tmp2 = tmp2.replace((uint)tmp2.find(separator, 0, false), (uint)separator.length(), "\n");
						}
						alias = prof->nextAlias();
					}
					tmp2.append("\n");
					s.append(tmp2);
				}
				else {
					alias = prof->firstAlias();
				
					while (alias != NULL) {
						if (alias->name == tmp1) {
							tmp1 = alias->definition;
							if (tmp1.find(separator, 0, true) >= 0) 
								while (tmp1.find(separator, 0, true) >= 0)
									tmp1 = tmp1.replace((uint)tmp1.find(separator, 0, false), (uint)separator.length(), "\n");
						}
						alias = prof->nextAlias();
					}

					s.append(tmp1);
					tmp1 = "";
					s.append("\n");
				}
			} // end of   while (tmp1 != "")
		} // end of   if (separator != "")
		else {
			s.append(tmp1);
			s.append("\n");
		}

	}
	else 
		s.append("\n");

/*	if ((localEchoMode==1) || ((localEcho==true) && (localEchoMode==2))) {
		//output->append(s,localEchoColor,output->getBackground(),output->getFont());
		splitoutput->append(s,localEchoColor,output->getBackground(),output->getFont());
	} else {
		//output->append("\n",localEchoColor,output->getBackground(),output->getFont());
		splitoutput->append("\n",localEchoColor,output->getBackground(),output->getFont());
	}*/ //handled elswhere
	input->addInputToHistory(s);
	emit enteredInput(s);
//	input->clear();
}

void KmudView::slotInputReturnPressed(QString s)
{
	QString tmp1, tmp2;
	AliasEntry* alias;
	CCharacterProfile* prof;
	//QString s = input->text();

	prof = document->getCharacterProfile(document->getCurrentCharacterID());
	if (prof)
	{
		/** Parse semi-colons */
		alias = prof->firstAlias();
		tmp1 = s;
		s = "";

		/** bugfix to allow the enter character by itself */
		if (tmp1 == QString("")) {
			s = "\n";
		}

		/** This code parses input, replaces ; with \n, and parses
		 ** aliases into their definitions.
		 **/
		if (separator != "") { // Empty disables
			while (tmp1 != "") {
				if (tmp1.contains(separator)) {
					uint pos = (uint)tmp1.find(separator, 0, false);

					tmp2 = tmp1;
					tmp2.truncate(pos);
					tmp1.remove(0, pos);
					if (tmp1.find(separator, 0, true) == 0)
						tmp1.remove(0, separator.length());

					alias = prof->firstAlias();
					while (alias != NULL) {
						if (alias->name == tmp2) {
							tmp2 = alias->definition;
							if (tmp2.find(separator, 0, true) >= 0)
								while (tmp2.find(separator, 0, true) >= 0)
									tmp2 = tmp2.replace((uint)tmp2.find(separator, 0, false), (uint)separator.length(), "\n");
						}
						alias = prof->nextAlias();
					}
					tmp2.append("\n");
					s.append(tmp2);
				}
				else {
					alias = prof->firstAlias();
					while (alias != NULL) {
						if (alias->name == tmp1) {
							tmp1 = alias->definition;
							if (tmp1.find(separator, 0, true) >= 0) 
								while (tmp1.find(separator, 0, true) >= 0) 
									tmp1 = tmp1.replace((uint)tmp1.find(separator, 0, false), (uint)separator.length(), "\n");
						}
						alias = prof->nextAlias();
					}

					s.append(tmp1);
					tmp1 = "";
					s.append("\n");
				}
			} // end of   while (tmp1 != "")
		} // end of   if (separator != "")
		else {
			s.append(tmp1);
			//s.append("\n");
		}

	} 
	else 
		s.append("\n");

	// slotAppendToOutput(s);
	//incase we didn't add a \n to the string yet:
	if (!(s.contains('\n', FALSE)))
	{
		s.append("\n");
	} // if
	
	emit enteredInput(s);
//	input->clear();
}

void KmudView::slotInput2ReturnPressed()
{
	QString s = input2->text();

	s.append("\n");
	slotAppendToOutput(s);

	emit enteredInput(s);
	input2->clear();

}

QString KmudView::slotAppendToOutput(QString s)
{
	QString returnString;

	if ((localEchoMode==1) || ((localEcho==true) && (localEchoMode==2))) {
		returnString = output->append(s,localEchoColor,output->getBackground(),output->getFont());
		splitoutput->append(s,localEchoColor,output->getBackground(),output->getFont());
	} else {
		returnString = output->append("\n",localEchoColor,output->getBackground(),output->getFont());
		splitoutput->append("\n",localEchoColor,output->getBackground(),output->getFont());
	}
	return returnString;
}

void KmudView::slotMudClosed()
{
	output->append(i18n("\nConnection closed by foreign host.\n"),output->getForeground(),output->getBackground(),output->getFont());
	splitoutput->append(i18n("\nConnection closed by foreign host.\n"),output->getForeground(),output->getBackground(),output->getFont());
}


bool KmudView::getLocalEcho()
{
	return localEcho;
}

void KmudView::setLocalEcho(bool b)
{
	localEcho=b;
}

int KmudView::getLocalEchoMode()
{
	return localEchoMode;
}

void KmudView::setLocalEchoMode(int i)
{
	localEchoMode=i;
}

bool KmudView::getInputEcho()
{
	return inputEcho;
}

void KmudView::setInputEcho(bool b)
{
	inputEcho=b;

	if ((inputEchoMode==0)||((inputEchoMode==2)&&(b==false))) {
		input->setEchoMode(QLineEdit::NoEcho);
		input2->setEchoMode(QLineEdit::NoEcho);
	} else  {
		input->setEchoMode(QLineEdit::Normal);
 		input2->setEchoMode(QLineEdit::Normal);
	}
}

int KmudView::getInputEchoMode()
{
	return inputEchoMode;
}

void KmudView::setInputEchoMode(int i)
{
	inputEchoMode=i;
	
	if ((i==0)||((i==2)&&(inputEcho==false))){
		input->setEchoMode(QLineEdit::NoEcho);
		input2->setEchoMode(QLineEdit::NoEcho);
	} else {
		input->setEchoMode(QLineEdit::Normal);
		input2->setEchoMode(QLineEdit::Normal);
	}
}

void KmudView::setAltInput(bool b)
{
	if (b)
	{
		input2->show();
		resizeEvent(NULL);
	}
	else
	{
		input2->hide();
		resizeEvent(NULL);
	}
}

void KmudView::setMaxHistoryLines(int l)
{
	input->setMaxHistoryLines(l);
	input2->setMaxHistoryLines(l);
}


void KmudView::setMaxMudViewLines(int l)
{
	output->setMaxLines(l);
}


bool KmudView::getKeepLastInput()
{
	return input->getKeepLastInput();
}

void KmudView::setKeepLastInput(bool b)
{
	input->setKeepLastInput(b);
	input2->setKeepLastInput(b);
}

bool KmudView::getSelectAllOnFocus()
{
	return input->getSelectAllOnFocus();
}

void KmudView::setSelectAllOnFocus(bool b)
{
	input->setSelectAllOnFocus(b);
	input2->setSelectAllOnFocus(b);
}

void KmudView::setSeparator(QString s) {
	separator = s;
}

QString KmudView::getSeparator() {
	return separator;
}

void KmudView::setAutoReconnect(bool b)
{
	autoReconnect = b;
}

bool KmudView::getAutoReconnect()
{
	return autoReconnect;
}

void KmudView::setAutoTime(unsigned int t)
{
	autoTime = t;
}

unsigned int KmudView::getAutoTime()
{
	return autoTime;
}

bool KmudView::getUseBeep() {
	return output->getUseBeep();
}

void KmudView::setUseBeep(bool u) {
	output->setUseBeep(u);
}

void KmudView::slotChangeSplitMode(bool on)
{
	splitMode=on;
	recalcWidgetSizes();
	repaint();
}

/** returns the Inputline */
CMudLineEdit* KmudView::getInput ()
{
	return input;
} // getInput

/** returns the character, that starts a speedwalking sequence */
QString KmudView::getSpeedwalkingChar ()
{
	return speedwalkingChar;
} // getSpeedwalkingChar

/** sets the character, that starts a speedwalking-sequence */
void KmudView::setSpeedwalkingChar (QString s)
{
	speedwalkingChar = s;
} // setSpeedwalkingChar

/** returns the ExternCommandChar */
QString KmudView::getExternChar()
{
	return externCommandChar;
} // getExternChar

/** set's the external command char */
void KmudView::setExternChar (QString externChar)
{
	externCommandChar = externChar;
} // setExternChar
