#include "feld.h"

typedef struct feldStruct {
    QString  name;
    Strasse* str;
    Bahnhof* bahn;
    int      id;
    QString  besitzer;
    int      typ;
    int      farbe;
    int      wert;
    struct   feldStruct* next;
};

struct feldStruct *flast, *fhead, *fcursor, *ftemp;

bool initialized = FALSE;

Spieler* mySpieler;

Feld::Feld ( ) {
 if (!initialized) {
    mySpieler = new Spieler ("_m(0.0)m_");
    int i;
    for (i = 1; i <= anzFelder; i++) {
	ftemp = new feldStruct;
	ftemp->id = i;
	ftemp->besitzer = "";
	ftemp->next     = NULL;
	ftemp->name     = fDaten[i].name;
	ftemp->typ      = fDaten[i].typ;
	ftemp->farbe    = fDaten[i].farbe;
	ftemp->wert     = fDaten[i].wert;
	if (fDaten[i].typ == STRASSEN) ftemp->str = new Strasse (fDaten[i].wert, fDaten[i].miete1, fDaten[i].miete2, fDaten[i].miete3, fDaten[i].miete4, fDaten[i].miete5, fDaten[i].miete6);
	if (fDaten[i].typ == BAHNHOEFE) ftemp->bahn = new Bahnhof (fDaten[i].wert, fDaten[i].miete1, fDaten[i].miete2, fDaten[i].miete3, fDaten[i].miete4 );
	if (fhead == NULL) {
	    fhead = ftemp;
	} else {
	    fcursor = fhead;
	    while (fcursor->next != NULL) {
		fcursor = fcursor->next;
	    };
	    fcursor->next = ftemp;
	};
    };
 initialized = TRUE;
 };
};

bool Feld::kaufen ( QString name, int feldNr ) {
    fcursor = fhead;
    if (fcursor == NULL) return FALSE;
    while (fcursor != NULL) {
	if (fcursor->id == reihenfolge[feldNr]) {
	    if (!kaufbar (feldNr)) return FALSE;
	    if (fcursor->besitzer == "") {
		if (mySpieler->zahlen (name, fcursor->wert)) {
		    fcursor->besitzer = name;
		    return TRUE; 
		} else {return FALSE; };
	    } else { return FALSE; };	
	};
	fcursor = fcursor->next;
    };
    return FALSE;
};

void Feld::hypothek ( QString name ) {
/*    switch (typ) {
	case STRASSEN : { if (!dummyStrasse->hypothekBeflastet ()) dummyStrasse->hypothek (); break; };
    }; */
};

bool Feld::miete ( QString name, int feldNr ) {
    QString s;
    const char* c;
    int i;
    
    if (mySpieler->besitzt (name, Feld::name (feldNr))) return TRUE;
    fcursor = fhead;
    while (fcursor != NULL) {
	if (fcursor->name == Feld::name (feldNr)) {
	    if (fcursor->besitzer == "") return TRUE;
	    if (fcursor->typ == STRASSEN) {
		i = fcursor->str->miete ();
		
		if (mySpieler->darfBauen (fcursor->besitzer, fcursor->name)) i *= 2;
		
		if ((mySpieler->zahlen (name, i)) && (mySpieler->verdienen (fcursor->besitzer, i))) {
		    c = fcursor->besitzer;
		    s.sprintf ("Die Miete in Hoehe von %i,- wurde an %s gezahlt.", i, c);
		    c = s;
		    if ((!fcursor->besitzer.contains ("CPU")) || (!name.contains ("CPU"))) QMessageBox::information (0, "Miete", c);
		    return TRUE;
		};
		return FALSE;
	    };
	    if (fcursor->typ == BAHNHOEFE) {
		i = 0;
		if (mySpieler->besitzt (fcursor->besitzer, "Suedbahnhof")) i++;
		if (mySpieler->besitzt (fcursor->besitzer, "Westbahnhof")) i++;
		if (mySpieler->besitzt (fcursor->besitzer, "Hauptbahnhof")) i++;
		if (mySpieler->besitzt (fcursor->besitzer, "Nordbahnhof")) i++;
		i = fcursor->bahn->miete (i);
		if ((mySpieler->zahlen (name, i)) && (mySpieler->verdienen (fcursor->besitzer, i))) {
		    c = fcursor->besitzer;
		    s.sprintf ("Die Miete in Hoehe von %i,- wurde an %s gezahlt.", i, c);
		    c = s;
		    QMessageBox::information (0, "Miete", c);
		    return TRUE;
		};
		return FALSE;
	    };	
	    return FALSE;
	};
	fcursor = fcursor->next;
    };
    return FALSE;
};

bool Feld::kaufbar ( int feldNr ) {
    fcursor = fhead;
    while (fcursor != NULL) {
	if (fcursor->id == reihenfolge[feldNr]) {
	    if (fcursor->besitzer == "") {
		switch (fcursor->typ) {
		    case STRASSEN : { return TRUE; };
		    case BAHNHOEFE: { return TRUE; };
		    default       : { return FALSE; };
		};
	    } else return FALSE;
	};
	fcursor = fcursor->next;
    };
    return FALSE;
};

int Feld::typ ( QString name ) {
    fcursor = fhead;
    while (fcursor != NULL) {
	if (fcursor->name == name) {
	    return (fcursor->typ);
	};
	fcursor = fcursor->next;
    };
    return 0;
};

int Feld::farbe ( QString name ) {
    fcursor = fhead;
    while (fcursor != NULL) {
	if (fcursor->name == name) {
	    return (fcursor->farbe);
	};
	fcursor = fcursor->next;
    };
    return 0;
};


QString Feld::besitzer ( QString name ) {
    fcursor = fhead;
    if (fhead == NULL) return 0;
    while (fcursor != NULL) {
	if (fcursor->name == name) return fcursor->besitzer;
	fcursor = fcursor->next;
    };
    return 0;
};    

bool Feld::bauen ( QString name, int gebaeude ) {
    int betrag;
    int bg;
    
    fcursor = fhead;
    if (fhead == NULL) return FALSE;
    if (typ (name) != STRASSEN) return FALSE;
    while (fcursor != NULL) {
	if (fcursor->name == name) {
	    switch (fcursor->farbe) {
		case 1 : { betrag = 1000; break; };
		case 2 : { betrag = 1000; break; };
		case 3 : { betrag = 2000; break; };
		case 4 : { betrag = 2000; break; };
		case 5 : { betrag = 3000; break; };
		case 6 : { betrag = 3000; break; };
		case 7 : { betrag = 4000; break; };
		case 8 : { betrag = 4000; break; };
		default   : betrag = 0;
	    };
	    bg = fcursor->str->gebaeude ();
	    if ((gebaeude - bg) > 0) {
		if (mySpieler->zahlen (besitzer (name), betrag * (gebaeude - bg))) {
		    if (fcursor->str->bauen (gebaeude)) return TRUE;
		};
	    } else {
		if (mySpieler->verdienen (besitzer (name), (betrag / 2) * (bg - gebaeude))) {
		    if (fcursor->str->bauen (gebaeude)) return TRUE;
		};
	    };
	};
	fcursor = fcursor->next;
    };
    return FALSE;
};

QString Feld::name ( int feldNr ) {
    fcursor = fhead;
    if (fhead == NULL) return 0;
    while (fcursor != NULL) {
	if (fcursor->id == reihenfolge[feldNr]) return fcursor->name;
	fcursor = fcursor->next;
    };
    return 0;
};    

int Feld::ID (QString name) {
    fcursor = fhead;
    if (fhead == NULL) return 0;
    while (fcursor != NULL) {
	if (fcursor->name == name) return fcursor->id;
	fcursor = fcursor->next;
    };
    return 0;
};

int Feld::ID2 (QString name) {
    int     IDii;
    QString IDss;
    fcursor = fhead;
    if (fhead == NULL) return 0;
    while (fcursor != NULL) {
	if (fcursor->name == name) {
	    for (IDii = 1; IDii <= 40; IDii++) {
		IDss = fDaten[reihenfolge[IDii]].name;
		if (IDss == name) return IDii;
	    };
	};
	fcursor = fcursor->next;
    };
    return 0;
};

int Feld::gebaeude (QString name) {
    fcursor = fhead;
    while (fcursor != NULL) {
	if (fcursor->name == name) {
	    if (fcursor->typ == STRASSEN) return fcursor->str->gebaeude ();
	};
	fcursor = fcursor->next;
    };
};