#include "spielerWidget.h"

SpielerWidget::SpielerWidget (QWidget* parent, const char *name) : QFrame (parent, name) {
    setFixedSize (230, 160);
    setFrameStyle (QFrame::WinPanel | QFrame::Raised);


    dLabel = new QLabel ("Spieler 1:", this);
    dLabel->setGeometry (10, 10, 80, 20);
    
    spieler[1] = new QLineEdit (this);
    spieler[1]->setGeometry (100, 10, 90, 20);

    dLabel = new QLabel ("Spieler 2:", this);
    dLabel->setGeometry (10, 40, 80, 20);
    
    spieler[2] = new QLineEdit (this);
    spieler[2]->setGeometry (100, 40, 90, 20);
    
    dLabel = new QLabel ("Spieler 3:", this);
    dLabel->setGeometry (10, 70, 80, 20);
    
    spieler[3] = new QLineEdit (this);
    spieler[3]->setGeometry (100, 70, 90, 20);
    
    dLabel = new QLabel ("Spieler 4:", this);
    dLabel->setGeometry (10, 100, 80, 20);
    
    spieler[4] = new QLineEdit (this);
    spieler[4]->setGeometry (100, 100, 90, 20);
    
    spielerSlider = new QSlider (1, 4, 1, 1, QSlider::Vertical, this);
    spielerSlider->setGeometry (200, 20, 20, 90);
    connect (spielerSlider, SIGNAL (valueChanged (int)), this, SLOT (slChanged (int)));
    slChanged (1);
    
    startBtn = new QPushButton ("Start", this);
    startBtn->setGeometry (60, 130, 80, 20);
    connect (startBtn, SIGNAL (clicked ()), this, SLOT (startPressed ()));
};

void SpielerWidget::startPressed () {
//    startBtn->hide ();
    
    for (int i = 1; i <= 4; i++) {
        s = spieler[i]->text ();
	
	if ((s.length () < 1) && (!spieler[i]->isEnabled ())) {
	    s.setNum (i);
	    s.insert (0, "CPU");
	};
	
	if ((s.length () < 1) && (spieler[i]->isEnabled ())) {
	    s.setNum (i);
	    s.insert (0, "Spieler");
	};
	
        new Spieler (s);
	spieler[i]->setText (s);
        spieler[i]->setEnabled (FALSE);
	
	dSR.spieler[i] = s;
    };
    emit ( letsGo (dSR) );
};

void SpielerWidget::resizeEvent (QResizeEvent *) {
};

void SpielerWidget::slChanged (int si) {
    int sii;
    
    for (sii = 1; sii <= 4; sii++) {
	if (sii <= si) {
	    spieler[sii]->setEnabled (TRUE);
	} else {
	    spieler[sii]->setEnabled (FALSE);
	};
    };
};