#ifndef KPACMANWIDGET_H
#define KPACMANWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qregexp.h>

#include "score.h"
#include "referee.h"
#include "status.h"
#include "painter.h"

class KPacmanWidget : public QWidget
{
    Q_OBJECT
public:
    KPacmanWidget ( QWidget *parent = 0, const char *name = 0, KConfig *conf = 0, int scheme = -1 );
    virtual ~KPacmanWidget();

    void setScheme(KConfig *conf = 0, int scheme = -1);
    Score *score;
    Referee *referee;
    Status *status;

protected:
    void getScheme(KConfig *conf = 0, int scheme = -1);
    void resizeEvent( QResizeEvent * );

private:
    Bitfont *bitfont;
    uchar bitfontFirstChar;
    uchar bitfontLastChar;

    QString fontName;
    QString pixDir;
};

#endif // KPACMANWIDGET_H

