#include <kmsgbox.h>
#include <stdarg.h>
#include <unistd.h>
#include "rogue/dun.h"
#include "kmsgbar.h"
#include "roguec.h"
#include "krogue.h"
#include "kdun.h"

unsigned short vdungeon[DROWS][DCOLS];

void turn_into_games()
{
  if (true_uid!=0) setuid(saved_uid);
}

void turn_into_user()
{
  if (true_uid!=0) setuid(true_uid);
}

const char *_i18n(const char *str)
{
  return i18n(str);
}

void clean_up(char *str)
{
  if (str!=NULL && str[0]!='\0')
    KMsgBox::message(NULL, i18n("Rogue"), loc->translate(str));
  kapp->quit();
  exit(1);
}

void killed_by(object *obj, short other)
{
  dun->killedBy(obj, other);
}

void redrawr(int row1, int col1, int row2, int col2)
{
  if (!msg->willQuit)
    dun->updatePixmap(row1, col1, row2, col2);
}

void redraw(int row, int col)
{
  if (!msg->willQuit)
    redrawr(row, col, row, col);
}

void message(char *str, int intr)
{
  if (intr) interrupted=1;
  msg->message(str);
}

void krogue_message(const char *str)
{
  KMsgBox::message(NULL, i18n("Rogue"), str);
}

void print_stats(int i)
{
  top->printStats(i);
}

void win()
{
  dun->win();
}

const char form_names[][20]=
{
  "",
  "object",
  "monster",
  "plural",
  "plural",
  "color",
  "potion",
  "scroll",
  "material",
  "wand",
  "armor",
  "ring",
  "gem"
};

void do_aan(char *dest, const char *src, int n)
{
  int i, ps=1;
  for (i=0; i<n-1; i++)
  {
    *(dest++)=*src;
    if (!*src) return;
    if (*src==' ' || *src=='\t' || *src=='\n')
    {
      if (ps==2)
      {
        if (is_vowel(*(src+1)))
	{
	  dest--;
	  *(dest++)='n';
	  *(dest++)=*src;
	  i++;
	}
      } else ps=1;
      src++;
      continue;
    }
    if (*src=='a' && ps==1)
    {
      src++;
      ps=2;
      continue;
    }
    src++;
    ps=0;
  }
  if (i>=n) i=n-1;
  dest[i]=0;
}

char *format_str(char *buf, const char *str, const char *sn, int argc, ...)
{
  char buf2[MSGLEN], *bufptr, numbuf[30];
  const char *cptr;
  int argt[10], argv, i;
  QString fmt=str, newstr;
  char *args[10];
  va_list valist;
  va_start(valist, argc);
  for (i=0; i<argc; i++)
  {
    argt[i]=va_arg(valist, int);
    argv=va_arg(valist, int);
    args[i]=va_arg(valist, char *);
    if (argt[i]==SNUMBER || argt[i]==LNUMBER)
    {
      long l;
      if (argt[i]==LNUMBER) l=*((long *)args[i]);
        else l=*((short *)args[i]);
      if (l==1) argv=20;
      else
      {
        argv=l%100;
        if (argv>=20) argv%=10;
      }
      snprintf(numbuf, 30, "%ld", l);
      args[i]=numbuf;
    }
//    printf("argt=%d, argv=%d, args=%s\n", argt, argv, args[i]);
    if (argt[i]!=STRING)
    {
      snprintf(buf2, 160, "_form.%s.%s", sn, form_names[argt[i]]);
//      printf("formstr=%s\n", buf2);
      cptr=i18n(buf2);
      if (cptr[0]!='_' && cptr[argv]!=' ')
      {
        fmt+=cptr[argv];
//        printf("c=%c\n", cptr[argv]);
      }
    }
  }
//  printf("fmt=%s\n", (const char *)fmt);
  cptr=i18n(fmt);
//  printf("tfmt=%s\n", cptr);
  newstr=0;
//  printf("new=%s\n", (const char *)newstr);
  while (*cptr)
  {
    if (*cptr!='$' || *(++cptr)!='{')
    {
      newstr+=*(cptr++);
//      printf("new=%s, cptr=%s\n", (const char *)newstr, cptr);
      continue;
    }
    i=*(++cptr)-'0';
    if (i<0 || i>=argc) continue;
//    printf("transl_id: %d\n", i);
    qstrncpy(buf2, args[i], MSGLEN);
    bufptr=&buf2[strlen(buf2)];
    while (*(++cptr)!='}')
    {
      *(bufptr++)=*cptr;
    }
    *bufptr=0;
    cptr++;
//    printf("transl: %s->%s\n", buf2, i18n(buf2));
    if (buf2[0]!=0) 
      if (argt[i]!=STRING) newstr+=i18n(buf2); else newstr+=buf2;
//    printf("new=%s\n", (const char *)newstr);
  }
//  printf("str=%s\n", (const char *)newstr);
  va_end(valist);
  if (loc->language()==QString("C") || (strcmp(loc->translate("_rules"), "aan")==0))
    do_aan(buf, (const char *)newstr, MSGLEN);
    else qstrncpy(buf, (const char *)newstr, MSGLEN);
//  printf("buf=%s, len=%d, lennew=%d\n", buf, strlen(buf), strlen((const char *)newstr));
  return buf;
}

void clear(void)
{
  memset(vdungeon, 0, sizeof(vdungeon));
  dun->clear();
}