/* ********************************************************************************
  This file is part of the kde-game 'KTron'

  Copyright (C) 1998,1999 by Matthias Kiefer <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  *******************************************************************************/  

#ifndef PLAYER_H
#define PLAYER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>

enum Direction{ Up, Down, Left, Right};

/**
* @short This class represents a player with current position and several flags
*/
class player
{
public:
  player();
  void reset();
  void setCoordinates(int x, int y);
  void setComputer(bool computer);

  int xCoordinate,yCoordinate;
  int score;
  bool alive;
  Direction dir;
  bool accelerated;
  bool keyPressed;
  bool computer;
};





#endif // PLAYER_H


