#include "main.h"

#include <kapp.h>
#include <ktmainwindow.h>

#include "kwormwidget.h"
#include "ball.h"

#include <qpixmap.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qfile.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

QPixmap* _BallRed1;
QPixmap* _BallGreen1;
QPixmap* _BallBlue1;
QPixmap* _BallYellow1;
QPixmap* _BallRed2;
QPixmap* _BallGreen2;
QPixmap* _BallBlue2;
QPixmap* _BallYellow2;
QPixmap* _BallRed3;
QPixmap* _BallGreen3;
QPixmap* _BallBlue3;
QPixmap* _BallYellow3;

QPixmap** _BallPixmapArray;

QPixmap** _BackgroundArray;
int _BackgroundArrayLen;

QPixmap* _Wall01;
QPixmap* _Wall02;
QPixmap* _Wall03;

QPixmap* _Separator;
QPixmap* _Cutter;

QPixmap* _OW_Right;
QPixmap* _OW_Left;
QPixmap* _OW_Up;
QPixmap* _OW_Down;

QPixmap* _Exit01;
QPixmap* _Exit01Open;

QPixmap* _Tele01;
QPixmap* _Tele01Open;

QPixmap* _BorderHrz;
QPixmap* _BorderVrt;
QPixmap* _BorderUL;
QPixmap* _BorderUR;
QPixmap* _BorderLL;
QPixmap* _BorderLR;

QPixmap* _WormHrz;
QPixmap* _WormVrt;
QPixmap* _WormEdgeUL;
QPixmap* _WormEdgeUR;
QPixmap* _WormEdgeLL;
QPixmap* _WormEdgeLR;
QPixmap* _WormTailDown;
QPixmap* _WormTailUp;
QPixmap* _WormTailLeft;
QPixmap* _WormTailRight;

QPixmap* _WormHeadRight;
QPixmap* _WormHeadLeft;
QPixmap* _WormHeadUp;
QPixmap* _WormHeadDown;

QPixmap* _WormTeleportRight;
QPixmap* _WormTeleportLeft;
QPixmap* _WormTeleportUp;
QPixmap* _WormTeleportDown;
QPixmap* _WormTeleportExitRight;
QPixmap* _WormTeleportExitLeft;
QPixmap* _WormTeleportExitUp;
QPixmap* _WormTeleportExitDown;

QPixmap* _Icon;

#define MakePixmap(a) new QPixmap(datadir + a)
#define MakeBitmap(a) QBitmap(datadir + a)

void getDatadir(char* datadir)
{
	KApplication* app = KApplication::getKApplication();
	QString ddir = app->kde_datadir();
	QString appName = app->appName();
	ddir = ddir + "/" + appName + "/";
	strcpy(datadir,(const char*) ddir);
}

void loadGamePixmaps()
{
	QBitmap bmp;
	KApplication* app = KApplication::getKApplication();
	QString datadir = app->kde_datadir();
	QString appName = app->appName();
	datadir = datadir + "/" + appName + "/";
 
	// Transformations
	QWMatrix flipHrz(-1,0,0,1,0,0);
	//	QWMatrix flipVrt(1,0,0,-1,0,0);
	QWMatrix rot90; rot90.rotate(90);
	QWMatrix rot270; rot270.rotate(270);
	
	_BallRed1 = MakePixmap("ballred1.xpm");
	_BallGreen1 = MakePixmap("ballgreen1.xpm");
	_BallBlue1 = MakePixmap("ballblue1.xpm");
	_BallYellow1 = MakePixmap("ballyellow1.xpm");
	bmp = MakeBitmap("ball1_mask.xpm");
	_BallRed1->setMask(bmp);
	_BallGreen1->setMask(bmp);
	_BallBlue1->setMask(bmp);
	_BallYellow1->setMask(bmp);

	_BallRed2 = MakePixmap("ballred2.xpm");
	_BallGreen2 = MakePixmap("ballgreen2.xpm");
	_BallBlue2 = MakePixmap("ballblue2.xpm");
	_BallYellow2 = MakePixmap("ballyellow2.xpm");
	bmp = MakeBitmap("ball2_mask.xpm");
	_BallRed2->setMask(bmp);
	_BallGreen2->setMask(bmp);
	_BallBlue2->setMask(bmp);
	_BallYellow2->setMask(bmp);

	_BallRed3 = MakePixmap("ballred3.xpm");
	_BallGreen3 = MakePixmap("ballgreen3.xpm");
	_BallBlue3 = MakePixmap("ballblue3.xpm");
	_BallYellow3 = MakePixmap("ballyellow3.xpm");
	bmp = MakeBitmap("ball3_mask.xpm");
	_BallRed3->setMask(bmp);
	_BallGreen3->setMask(bmp);
	_BallBlue3->setMask(bmp);
	_BallYellow3->setMask(bmp);

	_BallPixmapArray = (QPixmap**) malloc(sizeof(QPixmap*) * NUM_PIXMAPS * 3 + 1);
	_BallPixmapArray[0] = _BallRed1;
	_BallPixmapArray[1] = _BallRed2;
	_BallPixmapArray[2] = _BallRed3;
	_BallPixmapArray[3] = _BallGreen1;
	_BallPixmapArray[4] = _BallGreen2;
	_BallPixmapArray[5] = _BallGreen3;
	_BallPixmapArray[6] = _BallBlue1;
	_BallPixmapArray[7] = _BallBlue2;
	_BallPixmapArray[8] = _BallBlue3;
	_BallPixmapArray[9] = _BallYellow1;
	_BallPixmapArray[10] = _BallYellow2;
	_BallPixmapArray[11] = _BallYellow3;
	_BallPixmapArray[12] = 0;

	_Wall01 = MakePixmap("wall01.xpm");
	_Wall02 = MakePixmap("wall02.xpm");
	_Wall03 = MakePixmap("wall03.xpm");

	_Separator = MakePixmap("separator.xpm");
	_Separator->setMask(MakeBitmap("separator_mask.xpm"));
	_Cutter = MakePixmap("cutter.xpm");
	_Cutter->setMask(MakeBitmap("cutter_mask.xpm"));

	_OW_Right = MakePixmap("ow_right.xpm");
	_OW_Right->setMask(MakeBitmap("ow_right_mask.xpm"));
	_OW_Left = MakePixmap("ow_left.xpm");
	_OW_Left->setMask(MakeBitmap("ow_left_mask.xpm"));
	_OW_Up = MakePixmap("ow_up.xpm");
	_OW_Up->setMask(MakeBitmap("ow_up_mask.xpm"));
	_OW_Down = MakePixmap("ow_down.xpm");
	_OW_Down->setMask(MakeBitmap("ow_down_mask.xpm"));

	_Exit01 = MakePixmap("exit01.xpm");
	_Exit01Open = MakePixmap("exit01_open.xpm");

	_Tele01 = MakePixmap("tele01.xpm");
	_Tele01Open = MakePixmap("teleex01.xpm");

	_BorderHrz = MakePixmap("border_hrz.xpm");
	_BorderVrt = MakePixmap("border_vrt.xpm");
	_BorderUL = MakePixmap("border_ul.xpm");
	_BorderUR = MakePixmap("border_ur.xpm");
	_BorderLL = MakePixmap("border_ll.xpm");
	_BorderLR = MakePixmap("border_lr.xpm");

	_WormHrz = MakePixmap("worm_hrz.xpm");
	_WormHrz->setMask(MakeBitmap("worm_hrz_mask.xpm"));
	_WormVrt = new QPixmap(_WormHrz->xForm(rot270));

	_WormEdgeUL = MakePixmap("worm_edge_ul.xpm");
	_WormEdgeUL->setMask(MakeBitmap("worm_edge_ul_mask.xpm"));

	_WormEdgeUR = MakePixmap("worm_edge_ur.xpm");
	_WormEdgeUR->setMask(MakeBitmap("worm_edge_ur_mask.xpm"));

	_WormEdgeLL = MakePixmap("worm_edge_ll.xpm");
	_WormEdgeLL->setMask(MakeBitmap("worm_edge_ll_mask.xpm"));

	_WormEdgeLR = MakePixmap("worm_edge_lr.xpm");
	_WormEdgeLR->setMask(MakeBitmap("worm_edge_lr_mask.xpm"));

	_WormHeadRight = MakePixmap("worm_head_right.xpm");
	_WormHeadRight->setMask(MakeBitmap("worm_head_right_mask.xpm"));

	_WormHeadLeft = new QPixmap(_WormHeadRight->xForm(flipHrz));

	_WormHeadUp = new QPixmap(_WormHeadRight->xForm(rot270));

	_WormHeadDown = new QPixmap(_WormHeadLeft->xForm(rot270));

	_WormTailRight = MakePixmap("worm_tail_right.xpm");
	_WormTailRight->setMask(MakeBitmap("worm_tail_right_mask.xpm"));

	_WormTailLeft = new QPixmap(_WormTailRight->xForm(flipHrz));

	_WormTailUp = new QPixmap(_WormTailRight->xForm(rot270));

	_WormTailDown = new QPixmap(_WormTailLeft->xForm(rot270));

	_WormTeleportRight = MakePixmap("worm_tele_right.xpm");
	_WormTeleportRight->setMask(MakeBitmap("worm_tele_right_mask.xpm"));
	_WormTeleportExitRight = MakePixmap("worm_tele_exit_right.xpm");
	_WormTeleportExitRight->setMask(
		MakeBitmap("worm_tele_exit_right_mask.xpm"));

	_WormTeleportLeft = new QPixmap(_WormTeleportRight->xForm(flipHrz));
	_WormTeleportExitLeft = new QPixmap(_WormTeleportExitRight->xForm(flipHrz));

	_WormTeleportUp = new QPixmap(_WormTeleportRight->xForm(rot270));
	_WormTeleportExitUp = new QPixmap(_WormTeleportExitRight->xForm(rot270));

	_WormTeleportDown = new QPixmap(_WormTeleportRight->xForm(rot90));
	_WormTeleportExitDown = new QPixmap(_WormTeleportExitRight->xForm(rot90));

	_Icon = MakePixmap("kworm.xpm");
}
	
void loadBackgroundPixmaps()
{
	int i = 1;
	char fname[50];
	_BackgroundArray = NULL;
	KApplication* app = KApplication::getKApplication();
	QString datadir = app->kde_datadir();
	QString appName = app->appName();
	datadir = datadir + "/" + appName;
	sprintf(fname,"%s/bground%i.xpm",(const char*) datadir,i);
	while (QFile::exists(fname)) {
		QPixmap* pxm = new QPixmap(fname);
		_BackgroundArray = (QPixmap**) realloc(_BackgroundArray,i * sizeof(QPixmap*));
		_BackgroundArray[i - 1] = pxm;
		i++;
		sprintf(fname,"%s/bground%i.xpm",(const char*) datadir,i);
	}
	_BackgroundArrayLen = i - 1;

}

int main(int argc,char** argv)
{
	srand(time(NULL));

	KApplication a(argc,argv,"kworm");

	loadGamePixmaps();
	loadBackgroundPixmaps();

	KTMainWindow* mainWin = new KTMainWindow;

	KWormWidget mainWidget(mainWin);
	mainWin->setView(&mainWidget);

	a.setMainWidget(mainWin);
	mainWin->show();

	return a.exec();
}

 
