#ifndef __PLAYGROUND_H_INCLUDED__
#define __PLAYGROUND_H_INCLUDED__

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include <qpoint.h>
#include <qlist.h>
#include <qtimer.h>

#include "worm.h"
#include "maze.h"
#include "timewidget.h"

#define PGWIDTH 40
#define PGHEIGHT 40
#define START_X 20
#define START_Y 39
#define FDWIDTH 15
#define FDHEIGHT 15

// Runmodes - contained in CWormPlayground::_runMode
#define RM_NOT_STARTED 0
#define RM_RUNNING 1
// Restarting after winning a level or losing a life
#define RM_RESTARTING 2
#define RM_PAUSED 3
// Restarting, but waiting for a command to continue
#define RM_RESTART_STALLED 4

// Defines after how many timer-ticks the specified action will take place
#define TIMER_COUNT_WORM 2
#define TIMER_COUNT_WORM_GROW 30
#define TIMER_COUNT_BALL 1 
/* Will be multiplied with object-specific value */
#define TIMER_COUNT_BALL_REDRAW 3

// Reasons for terminating
#define DieWormCrash 1
#define DieWallCrash 10
// ???

#define DieTerminateCommand 100
#define DieRestartCommand 101
#define DieWon 111

// Field status (returned by fieldState, positive value->worm dies if accessing this field)
#define FieldEmpty 0
#define FieldWorm 1
#define FieldWall 10
#define FieldOW 20
#define FieldBorder 11
#define FieldUsedTeleport 30
#define FieldMagicBorder -11
#define FieldBall -1
#define FieldFreeOW -10
#define FieldExit 20
#define FieldOpenExit -20
#define FieldTeleport -30
#define FieldSeparator -40
#define FieldCutter -41

class KWormWidget;

class CWormPlayground : public QWidget
{
 Q_OBJECT

 // Data
 public:
	CWormPlayground(QWidget* parent,CTimeWidget* tb);
	virtual ~CWormPlayground();
	int runMode() { return _runMode; }
	CWorm* worm() { return _worm; }
	CMaze* maze() { return _maze; }
	unsigned int score() { return _score; }
	void setScore(unsigned int sc) { emit sigChangeScore(sc); _score = sc; }
	bool loseLife() { setLives(livesCount() - 1); return !livesCount(); }
	void winLife() { if (_livesCount < 6) _livesCount++; }
	void setLives(char l) { _livesCount = l; emit sigLivesCount(l); }
	char livesCount() { return _livesCount; }
	void setLevel(QString s,int n) { _levelSet = s; _levelNumber = n; }
	KWormWidget* _parent;

 protected:
	CWorm* _worm;
	CMaze* _maze;
	QTimer* _timer;
	QTimer* _restartTimer;
	CTimeWidget* _timerBar;
	long _timerCount;
	int _runMode;
	unsigned int _score;
	char _livesCount;
	QPixmap* _bgPixmap;

	QString _levelSet;
	int _levelNumber;
	
 // Implementation
 signals:
	void sigDie(char);
	void sigStart(); // Is only emitted when beginning a new game
	void sigRestart(); // New level, restart after losing a life
	void sigTimer(long);
	void sigNewDir(char);
	void sigChangeScore(unsigned int);
	void sigLivesCount(int);
	void sigTerminate();

 public slots:
        void slotDoStart();
	void slotDoRestart();
	void slotDoPause(bool force);

	//	void slotWormAccess(int x,int y);
        void slotStart();
	void slotRestart();
	void slotTimer();
	void slotTerminate(char reason);
	void slotEatBall(char sc);
	void slotSpecialUpdate(QRect r); // r is in logical ccordinates
	void slotChangeScore(unsigned int s);
	void slotChangeSpeed(int msec);

 public:
	QPoint LPtoDP(QPoint pt)/* { return QPoint(pt.x() * FDWIDTH,pt.y() * FDHEIGHT); }*/;
	QRect LPtoDP(QRect rct) /*{ return QRect(LPtoDP(rct.topLeft()),LPtoDP(rct.bottomRight())); }*/;
	QPoint DPtoLP(QPoint pt);
	QRect DPtoLP(QRect rct);
	void fwdKey(QKeyEvent* e);
	int fieldState(QPoint pt,char dir = 255);
	void winningLevel();
	bool wormAccess(int x,int y); // returns if worm should stop its actions

 protected:
	virtual void paintEvent(QPaintEvent* ev);
	/*	virtual void keyPressEvent(QKeyEvent* e);*/
	void showHighscoreDialog();
};

#endif // !__PLAYGROUND_H_INCLUDED__
