/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** anim.cpp
*/
#include "anim.h"
#include "base.h"

#include "evaluate.h"

#include <sys/stat.h>


anim::anim()
{
}

anim::anim(anim *ac)
{
	int	i;

	for(i = 0;i < ac->methodlist.length();i++)
	{
		methodlist += ac->methodlist[i];
	}
	for(i = 0;i < ac->scriptlist.length();i++)
	{
		scriptlist += ac->scriptlist[i];
	}
}

anim::~anim()
{
}

int	anim::callscript(char *fn,char *tmpdir,com *c,int time,int start,int end,int stepsize,param **pr,list<param*> *pl)
{
	FILE		*fp = 0;
	char		str[2048],str2[2048],*st = 0;
	int		len,ilen,t,i;
	int		timeout,timeout2;

	if(!c) return -1;

	for(t = 0;t < scriptlist.length();t++)
	{
		if(strcmp(scriptlist[t]->name(),fn) == 0)
		{
			st = scriptlist[t]->scripttext();
		}
	}

	if(st == 0) return -2;

	sprintf(str,"%s/%s-%s.sh",tmpdir,((base*)this)->getName(),fn);
	if((fp = fopen(str,"r")) == 0)
	{
		umask(0700);

		fp = fopen(str,"w");
		if(fp == 0) return -3;
		len = strlen(st);
		ilen = fwrite(st,1,len,fp);
		fclose(fp);

		sprintf(str2,"chmod 700 %s",str);
		system(str2);

		if(ilen != len) return -4;
	}
	else
	{
		fclose(fp);
	}
/*
	do
	{
		if(fp) fclose(fp);
		sprintf(str,"%s/tmp%i.sh",tmpdir,rand());
	}
	while((fp = fopen(str,"r")) != 0);	

	umask(0700);

	fp = fopen(str,"w");
	if(fp == 0) return -3;
	len = strlen(st);
	ilen = fwrite(st,1,len,fp);
	fclose(fp);

	sprintf(str2,"chmod 700 %s",str);
	system(str2);

	if(ilen != len) return -4;
*/

	c->start(str,time,start,end,stepsize);

	i = 0;
	timeout = timeout2 = 0;
	while(!0)
	{
		if(c->isRunning())
		{
			if(timeout < 100000000) // timeout
				timeout++;
			else
				break;
		}
		else
		{
			if(timeout2 < 1000) // timeout
				timeout2++;
			else
				break;
		}

		if(c->read(str2) == 0)
			continue;

		if(strncmp(str2,"PRNT",4) == 0)
		{
			printf("%s",str2 + 4);
			c->write("OK\n");
		}
		else if(strncmp(str2,"ERRR",4) == 0)
		{
			fprintf(stderr,"%s",str2 + 4);
			c->write("OK\n");
		}
		else if(strncmp(str2,"ARGC",4) == 0)
		{
			int	argc = 0;
			char	buffer[32];
			
			if(pl)
				argc = pl->length();
			
			sprintf(buffer,"%i",argc);	
			c->write(buffer);
			c->write("\n");
		}
		else if(strncmp(str2,"ARGV",4) == 0)
		{
			int	argc = 0;
			int	argn = 0;
			int	argt = 0;
			char	buffer[1024];
			
			if(pl)
				argc = pl->length();
				
			argn = atoi(str2 + 4);
			if(argn < argc)
			{
				argt = pl->at(argn)->type();
				switch(argt)
				{
					case param::PM_NONE:
						sprintf(buffer,"\n");
					break;
					case param::PM_BOOL:
						sprintf(buffer,"%s\n",(((pmbool*)pl->at(argn))->value()?"TRUE":"FALSE"));
					break;
					case param::PM_CHAR:
						sprintf(buffer,"%i\n",((pmchar*)pl->at(argn))->getChar());
					break;
					case param::PM_INT:
						sprintf(buffer,"%i\n",((pmint*)pl->at(argn))->getInt());
					break;
					case param::PM_REAL:
						sprintf(buffer,"%g\n",((pmreal*)pl->at(argn))->real());
					break;
					case param::PM_VECTOR:
						sprintf(buffer,"<%g,%g,%g>\n",
							((pmvector*)pl->at(argn))->vector()[0],
							((pmvector*)pl->at(argn))->vector()[1],
							((pmvector*)pl->at(argn))->vector()[2]);
					break;
					case param::PM_TEXT:
						sprintf(buffer,"%s\n",((pmtext*)pl->at(argn))->getText());
					break;
					case param::PM_OBJECT:
						sprintf(buffer,"%s\n",((pmobject*)pl->at(argn))->getName());
					break;
					default:
						sprintf(buffer,"\n");
					break;
				}
				c->write(buffer);
			}
			else
			{
				c->write("FAIL\n");
			}
		}
		else if(strncmp(str2,"ARGT",4) == 0)
		{
			int	argc = 0;
			int	argn = 0;
			int	argt = 0;
			
			if(pl)
				argc = pl->length();
				
			argn = atoi(str2 + 4);
			if(argn < argc)
			{
				argt = pl->at(argn)->type();
				switch(argt)
				{
					case param::PM_NONE:
						c->write("NONE\n");
					break;
					case param::PM_BOOL:
						c->write("BOOL\n");
					break;
					case param::PM_CHAR:
						c->write("CHAR\n");
					break;
					case param::PM_INT:
						c->write("INT\n");
					break;
					case param::PM_REAL:
						c->write("REAL\n");
					break;
					case param::PM_VECTOR:
						c->write("VECTOR\n");
					break;
					case param::PM_TEXT:
						c->write("TEXT\n");
					break;
					case param::PM_OBJECT:
						c->write("OBJECT\n");
					break;
					default:
						c->write("UNKNOWN\n");
					break;
				}
			}
			else
			{
				c->write("FAIL\n");
			}
		}
		else if(strncmp(str2,"SAVE",4) == 0)
		{
			char	*n,*v;

			n = strtok(str2 + 4,"=");
			v = strtok(0,"\n");
			setValue(n,v);
			c->write("OK\n");
		}
		else if(strncmp(str2,"LOAD",4) == 0)
		{
			char	*n,*v;

			n = str2 + 4;
			v = getValue(n);
			c->write(v);
			c->write("\n");
		}
		else if(strncmp(str2,"CALC",4) == 0)
		{
			char		*calcstr;
			ntuple_t	*ntuple = 0;
			paralist_t	plist = {0,0};
			int		t;
			char		retval[20];

			calcstr = strdup(str2 + 4);
			calcstr[strlen(calcstr) - 1] = 0;
//			printf("Calcstring: \"%s\"",calcstr);

			ntuple = eval_term(calcstr,&plist);
			if(ntuple)
			{
//				printf(" = <");
				for(t = 0;t < ntuple->ntuple;t++)
				{
					if(t == 0)
						sprintf(retval,"%.6f\n",ntuple->tuple[0]);
//					printf("%5.2f",ntuple->tuple[t]);
					if(t < ntuple->ntuple - 1) printf(",");
				}
//				printf(">");
			}
//			printf("\n");
			c->write(retval);
			free(calcstr);
		}
		else if(strncmp(str2,"EXIT",4) == 0)
		{
			break;
		}
		else if(strncmp(str2,"CMND",4) == 0)
		{
			char		*object,*command,*pstr;
			param		*p;
			list<param*>	pl;
			char		retval[256];

			object = strtok(str2 + 4," \n");
			command = strtok(0," \n");

			while((pstr = strtok(0," \n")) != 0)
			{
				makeParam(&p,pstr);
				pl += p;
			}

			p = 0;
			if(strncmp(object,"THIS",4) == 0)
			{
				call(command,&p,&pl,tmpdir,c,time,start,end,stepsize);
			}
			else
			{
				base	*bp2 = 0;

				bp2 = ((base*)this)->searchName(object);

				if(bp2 != 0)
				{
					((anim*)bp2)->call(command,&p,&pl,tmpdir,c,time,start,end,stepsize);
				}
			}
			if(p)
			{
				switch(p->type())
				{
					case param::PM_BOOL:
						sprintf(retval,"B%i",((pmbool*)p)->value()?1:0);
					break;
					case param::PM_CHAR:
						sprintf(retval,"C%c",((pmchar*)p)->getChar());
					break;
					case param::PM_INT:
						sprintf(retval,"I%i",((pmint*)p)->getInt());
					break;
					case param::PM_REAL:
						sprintf(retval,"R%g",((pmreal*)p)->real());
					break;
					case param::PM_VECTOR:
					{
						Vector3		v;

						v = ((pmvector*)p)->vector();
						sprintf(retval,"V%g %g %g",v[0],v[1],v[2]);
					}
					break;
					case param::PM_TEXT:
					{
						char		*s;

						s = ((pmtext*)p)->getText();
						sprintf(retval,"T%i %s",strlen(s),s);
					}
					break;
				}
			}
			else
			{
				retval[0] = '\0';
			}
			c->write(retval);
			c->write("\n");
		}
	}

	if(c->isRunning())
	{
		//printf("Timeout! Kill Script!\n");
		c->stop();
	}
	else
	{
		//printf("Script exited!\n");
	}

/*
	sprintf(str2,"rm %s",str);
	system(str2);
*/

	return 0;
}

void	anim::listMethods()
{
	int	t;

	for(t = 0;t < methodlist.length();t++)
		printf("%i. method: %s\n",t + 1,methodlist[t]->name());
}

void	anim::addScript(char *n,char *t)
{
	animscript	*s;

	s = new animscript(n,t);
	scriptlist += s;
}

void	anim::delScript(char *n)
{
	animscript	*s;
        int		i;

        for(i = 0;i < scriptlist.length();i++)
        {
		s = scriptlist[i];
		if(strcmp(s->name(),n) == 0)
			scriptlist.deleteCurrent();
	}
}

char	**anim::getScriptList()
{
	char	**nl;
	int	n;

	nl = (char**)malloc((scriptlist.length() + 1) * sizeof(char*));

	if(nl)
	{
		for(n = 0;n < scriptlist.length();n++)
		{
			nl[n] = strdup(scriptlist[n]->name());
		}
		nl[n] = 0;
	}

	return nl;
}

void	anim::setText(char *name,char *t)
{
	int	n;

	for(n = 0;n < scriptlist.length();n++)
	{
		if(strcmp(scriptlist[n]->name(),name) == 0)
		{
			scriptlist[n]->setScript(t);
		}
	}
}

char 	*anim::getText(char *name)
{
	int	n;

	for(n = 0;n < scriptlist.length();n++)
	{
		if(strcmp(scriptlist[n]->name(),name) == 0)
		{
			return scriptlist[n]->scripttext();
		}
	}

	return 0;
}

int	anim::call(char *n,param **pr,list<param*> *pl,char *tmpdir,com *c,int time,int start,int end,int stepsize)
{
	int	t;

	for(t = 0;t < scriptlist.length();t++)
	{
		if(strcmp(scriptlist[t]->name(),n) == 0)
		{
			int	result;

			result = callscript(n,tmpdir,c,time,start,end,stepsize,pr,pl);

			return result;
		}
	}

	for(t = 0;t < methodlist.length();t++)
	{
		if(strcmp(methodlist[t]->name(),n) == 0)
		{
			int	result;

			result = methodlist[t]->call(this,pr,pl);

			return result;
		}
	}
	printf("no such script or method \"%s\"\n",n);

	return -1;
}

int	anim::addMethod(char *n,methodfn f)
{
	methodlist += new method(n,f);

	return 0;
}

int	anim::delMethod(char *n)
{
	int	t;

	for(t = 0;t < methodlist.length();t++)
		if(strcmp(methodlist[t]->name(),n) == 0)
		{
			return (methodlist.deleteCurrent() == 0);
		}
	return -1;
}

int	anim::makeParam(param **p,char *pstr)
{
	if(*pstr == '<')
	{
		float	x,y,z;

		sscanf(pstr,"<%f,%f,%f>",&x,&y,&z);
		*p = new pmvector(x,y,z);
	}
	else if(isdigit(*pstr))
	{
		float	d;

		sscanf(pstr,"%f",&d);
		*p = new pmreal(d);
	}
	else
	{
		if(strcmp(pstr,"TRUE") == 0
		|| strcmp(pstr,"true") == 0)
		{
			*p = new pmbool(1);
		}
		else if(strcmp(pstr,"FALSE") == 0
		|| strcmp(pstr,"false") == 0)
		{
			*p = new pmbool(0);
		}
		else
		{
			*p = new pmtext(pstr);
		}
	}

	return 0;
}

int	anim::save(media *m)
{
	int	t;
        chunk	c;

	if(!m)	return -1;
	c.setMedia(m);

	c.writeChunk("ANIM");

	for(t = 0;t < scriptlist.length();t++)
	{
		c.writeNameChunk(scriptlist[t]->name());
		c.writeName(scriptlist[t]->scripttext());
	}
	
	c.writeChunkLen();

	return 0;
}

int	anim::load(media *m,int)
{
	char		chnk[4],*n,*t;
	int		len,pos;
        chunk		c;

	if(!m)	return -1;
	c.setMedia(m);

	pos = m->tell();

	m->read(chnk,4);
	m->read(&len,4);

	if(strncmp(chnk,"ANIM",4) != 0)
	{
		m->seek(-8,SEEK_CUR);
		return -1;
	}

	while(m->tell() - pos < len)
	{
		n = c.readNameChunk();
		t = c.readName();
		addScript(n,t);
	}

	return 0;
}

char	*anim::getValue(char *n)
{
	int		t;

	for(t = 0;t < variablelist.length();t++)
	{
		if(strcmp(variablelist[t]->name(),n) == 0)
		{
			return variablelist[t]->value();
		}
	}

	return 0;
}

void	anim::setValue(char *n,char *v)
{
	int		t;

	if(n == 0)
		return;

	for(t = 0;t < variablelist.length();t++)
	{
		if(strcmp(variablelist[t]->name(),n) == 0)
		{
			variablelist[t]->setValue(v);
			return;
		}
	}

	variable	*var;

	var = new variable(n,v);
	variablelist += var;
}



method::method(char *n,methodfn f)
{
	d_fn = f;
	if(n)
		d_name = strdup(n);
	else
		d_name = 0;
}

method::method(method *mc)
{
	if(mc->d_name)
		d_name = strdup(mc->d_name);
	else
		d_name = 0;
	d_fn = mc->d_fn;
}

method::~method()
{
	if(d_name)
		free(d_name);
	d_name = 0;
}

char	*method::name()
{
	return d_name;
}

int	method::call(anim *caller,param **pr,list<param*> *pl)
{
	typedef int (anim::*rt)(param**,list<param*>*);
	typedef rt *prt;

	if(d_fn == 0)
		return -1;

	rt	r;
	r = *((prt)(&d_fn));
	(caller->*r)(pr,pl);

	return 0;
}




animscript::animscript(char *n,char *t)
{
	if(n)
		d_name = strdup(n);
	else
		d_name = 0;
	if(t)
		d_script = strdup(t);
	else
		d_script = strdup("#!/bin/sh\n");
}

animscript::animscript(animscript *ac)
{
	if(ac->d_name)
		d_name = strdup(ac->d_name);
	else
		d_name = 0;
	if(ac->d_script)
		d_script = strdup(ac->d_script);
	else
		d_script = strdup("#!/bin/sh\n");
}

animscript::~animscript()
{
	if(d_name)
		free(d_name);
	if(d_script)
		free(d_script);
}

void	animscript::setScript(char *t)
{
	if(d_script) free(d_script);
	d_script = strdup(t);
}

char	*animscript::scripttext()
{
	return d_script;
}

char	*animscript::name()
{
	return d_name;
}

variable::variable(char *n,char *v)
{
	if(n)
		d_name = strdup(n);
	else
		d_name = 0;
	if(v)
		d_value = strdup(v);
	else
		d_value = 0;
}

variable::~variable()
{
	if(d_name)
		free(d_name);
	if(d_value)
		free(d_value);
}

void	variable::setValue(char *v)
{
	if(d_value)
		free(d_value);
	if(v)
		d_value = strdup(v);
	else
		d_value = 0;
}

char	*variable::value()
{
	return d_value;
}

char	*variable::name()
{
	return d_name;
}

