/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** param.h
*/
#ifndef __PARAM_H__
#define __PARAM_H__

#include <matmath.h>
#include <list.h>


class param
{
public:
typedef	enum	{
			PM_NONE,
			PM_BOOL,
			PM_CHAR,
			PM_INT,
			PM_REAL,
			PM_VECTOR,
			PM_LIST,
			PM_ARRAY,
			PM_TEXT,
			PM_OBJECT,
		}
		PM_TYPE;

protected:

	int	dvalid;
	PM_TYPE	pmtype;

public:

	param();
	virtual ~param();

	int	type();

	int	valid();
	void	setValidity(int v = 1);
};

class pmbool : public param
{
protected:

	int	dbool;

public:

	pmbool(int b = 0);

	int	value();

	void	setBool(int b);
};

class pmchar : public param
{
protected:
	char	dchar;

public:
	pmchar(char c = 0);

	char	getChar();
	void	setChar(char c);
};

class pmint : public param
{
protected:
	int	dint;

public:

	pmint(int i = 0);

	int	getInt();

	void	setInt(int i);
};

class pmreal : public param
{
protected:

	double	dreal;

public:

	pmreal(double r = 0);

	double	real();

	void	setReal(double r);
};

class pmvector : public param
{
protected:

	Vector3	dvector;

public:

	pmvector(Vector3 v = Vector3(0,0,0));
	pmvector(double x,double y = 0,double z = 0);

	Vector3	vector();

	void	setVector(Vector3 v);
};

class pmlist : public param
{
};

class pmarray : public param
{
};


class pmtext : public param
{
protected:

	char	*dtext;

public:

	pmtext(char *c = 0);

	char	*getText();

	void	setText(char *c);
};

class pmobject : public param
{
protected:

	char	*dname;

public:

	pmobject(char *c = 0);

	char	*getName();

	void	setName(char *c);
};


#endif

