/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** atom.h
*/
#ifndef __ATOM__
#define __ATOM__

#include "body.h"

class atom : public body
{
public:
	atom(base *parent = 0,const char *name = "Untitled",texture *t=0);
	atom(base*,const char*,Vector3&,Vector3&,Vector3&); 
	atom(base*,const char*,texture*,Vector3&,Vector3&,Vector3&); 
	atom(base*,atom*); 
	~atom();

	virtual int	exportPOV(FILE*,int tab,int tabsize,int anim = 0) = 0; 

	virtual int	addToParent(base*) = 0;
	virtual int	removeFromParent() = 0;

	virtual void	dumpNames(int,int);

	virtual int	draw(view*,Matrix44,int anim = 0) = 0; 
};


#endif

