/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** base.h
*/
#ifndef __BASE_H__
#define __BASE_H__

#include "misc.h"

#include "num.h"
#include "list.h"

#include "chunk.h"
#include "anim.h"
#include "boundingbox.h"
#include "dragvector.h"

#include "matmath.h"

class body;
class ref;
class refptr;
class csgobj;
class blobobj;
class sphere; 
class cylinder; 
class nonsolid;
class world;  

class view;  


class base : public chunk, public boundingbox, public anim
{
public:
typedef	enum	{
			DRAW_BOUNDINGBOX = 0,
			DRAW_BOUNDINGSPHERE,
			HIDE,
			NO_EXPORT,
			DRAW_AXIS,
			HOLLOW_ON,
			HOLLOW_OFF,
		}
		FLAGS;
typedef	enum	{
			DEFAULT = 0,
			NO_TEXTURE,
			NO_MODEL,
			VERSION_MASK = 0xfffff0
		}
		LOADFLAGS;

protected:
	char			*name;
	int			flags;
	NUM_TYPE		numtype;
	base			*parent;
	list<dragvector*>	dragvectorlist;

public:
	base(base *p = 0,const char *n="Untitled"); 
	base(base *p,base *bc); 
	virtual ~base();

	virtual base		*searchName(const char *n);
	virtual int		existsName(const char *n);
	virtual char		*createName(const char *basename);
	virtual const char	*getName();
	virtual int		setName(const char *n);

	virtual void		dumpNames(int tabsize = 2);
	virtual void		dumpNames(int,int) = 0;

	int			save3DDS(const char*,base*);
	int			load3DDS(const char*,base**);
	int			save3DDS(media*,base*);
	int			load3DDS(media*,base**); 
	virtual int		save(media*) { return -1;};
	virtual int		load(media*,int);

	int			saveFlags(media*);
	int			loadFlags(media*,int);

	virtual int		exportPOV(FILE*,int tab,int tabsize,int anim) = 0;

	int			getType() { return numtype; };
	int			type() { return numtype; };

	virtual void		getChildren(base ***b) { *b = 0;};

	virtual int		draw(view*,Matrix44,int anim = 0) = 0; 
	virtual Matrix44	getMatrix(int anim = 0); 

	void			addDragvector(dragvector *);
	int			drawDragvectors(view*,Matrix44,int);
	int			changeDragvector(view*,Matrix44,int fx,int fy,int tx,int ty);

	virtual int		addToParent(base*) {return -1;};
	virtual int		removeFromParent();

 	virtual int		addChild(base*) {return -1;};
	virtual int		addChild(body*) {return -1;};
	virtual int		addChild(refptr*) {return -1;};
	virtual int		addChild(ref*) {return -1;};
	virtual int		addChild(csgobj*) {return -1;};
	virtual int		addChild(blobobj*) {return -1;};
	virtual int		addChild(nonsolid*) {return -1;};

	virtual int		removeChild(base*) {return -1;};
	virtual int		removeChild(body*) {return -1;}; 
	virtual int		removeChild(refptr*) {return -1;}; 
	virtual int		removeChild(ref*) {return -1;}; 
	virtual int		removeChild(csgobj*) {return -1;}; 
	virtual int		removeChild(blobobj*) {return -1;}; 
	virtual int		removeChild(nonsolid*) {return -1;};  

	virtual int		hasChild(base*) {return -1;};
	virtual int		hasChild(body*) {return -1;}; 
	virtual int		hasChild(refptr*) {return -1;}; 
	virtual int		hasChild(ref*) {return -1;}; 
	virtual int		hasChild(csgobj*) {return -1;}; 
	virtual int		hasChild(blobobj*) {return -1;}; 
	virtual int		hasChild(nonsolid*) {return -1;};  

	virtual int		moveChild(base*) {return -1;};
	virtual int		moveChild(body*) {return -1;};
	virtual int		moveChild(refptr*) {return -1;};
	virtual int		moveChild(ref*) {return -1;};
	virtual int		moveChild(csgobj*) {return -1;};
	virtual int		moveChild(blobobj*) {return -1;};
	virtual int		moveChild(nonsolid*) {return -1;};

	virtual base		*copy(base *) {return 0;};

	virtual base		*getParent();
	virtual base		*getRoot();

	base			*parse(media*);
	void			setParent(base*);

	void			setFlag(FLAGS f,int set = 1);
	int			isFlag(FLAGS f);

	virtual int		isFinite();

	virtual int		calculate(int) = 0;

	int			asetflag(param**,list<param*>*);
	int			aclearflag(param**,list<param*>*);

};


#endif

