/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** blobobj.h
*/
#ifndef blobobject_inc
#define blobobject_inc

#include "csgobj.h"


class blobobj : public csgobj
{
protected:
	
	double strength;	

public:
		
	blobobj(base *b=0,const char *n="Untitled",double str = 2,texture *t=0);
	blobobj(base *b,const char *n,double str,Vector3&,Vector3&,Vector3&);
	blobobj(base *b,const char *n,double str,texture *t,Vector3&,Vector3&,Vector3&);
	blobobj(base *b,blobobj *bc);
	~blobobj();

	virtual int	exportPOV(FILE *,int,int,int anim = 0) = 0;

	virtual int	addToParent(base *) = 0;
	virtual int	removeFromParent() = 0;

	virtual void	dumpNames(int,int) = 0;

	virtual int	draw(view*,Matrix44,int) = 0; 

	int		isBlobObject();
};

#endif
