/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** blob.h
*/
#ifndef __BLOB_H__
#define __BLOB_H__

#include <classes.h>

class blob : public csgobj
{
protected:
	list<blobobj*>	bloblist;
	double		threshold;

public:
	blob(base *p=0,const char *n="Untitled",double treshhold = 0.5,texture *t=0);
	blob(base *p,const char *n,double tr,texture *t,Vector3&,Vector3&,Vector3&);
	blob(base *p,const char *n,double tr,Vector3&,Vector3&,Vector3&);
	blob(base *p,blob *bc);
	~blob();

	double		thresholdValue();
	void		setThresholdValue(double);

	virtual int	addToParent(base*);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual int	exportPOV(FILE*,int,int,int anim = 0);
	virtual void	dumpNames(int,int);

	virtual int	addChild(blobobj*);
	virtual int	removeChild(blobobj*);

	virtual void	getChildren(base ***b);

	virtual int	save(media*);
	virtual int	load(media*,int);

	virtual	base	*searchName(const char *n);
	virtual int	existsName(const char *n);

	virtual int	draw(view *v,Matrix44,int);
	virtual int	calculate(int);

	virtual double	volume(int anim = 0);
};

#endif
