/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** camera.cpp
*/
#include "camera.h"

camera::camera(base *p,const char *n,view *v) :
	body(p,n)
{
	numtype = NUM_CAMERA;

	if(parent)
		addToParent(parent);

	setView(v);
}

camera::camera(base *p,camera *cc) :
	body(p,cc)
{
	numtype = NUM_CAMERA;

	if(parent)
		addToParent(parent);

	// need copy ?
	viewptr = cc->viewptr;
}

camera::~camera()
{
	removeFromParent();
	if(viewptr)
	{
		viewptr->setCamera(0);
	}
}

void	camera::setView(view *v)
{
	viewptr = v;
	if(viewptr)
	{
		viewptr->setCamera(this);
	}
}

view	*camera::getView()
{
	return viewptr;
}

int	camera::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;

	return p->addChild(this);
}

int	camera::removeFromParent()
{ 
	if(!parent) return -2; 
 
	return parent->removeChild(this); 
} 

base	*camera::copy(base *p)
{
	return new camera(p,this);
}

int	camera::exportPOV(FILE *,int,int,int)
{
	return 0;
}

int	camera::calculate(int)
{
	return 0;
}

int	camera::draw(view *v,Matrix44 m,int anim)
{
	return -1;
}

void	camera::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("camera: %s\n",name);
}

int	camera::save(media *m)
{
	if(!m) return -1;

	setMedia(m);
	writeChunk("CMRA");
	writeNameChunk(name);
	saveFlags(m);

	if(viewptr)
		writeName(viewptr->getName());
        else
		writeName(0);
	
	anim::save(m);
	dim::save(m);

	writeChunkLen();

	return 0;
}

int	camera::load(media *m,int l)
{
	int	pos = m->tell();
	world	*w;
	char	*n;

	loadFlags(m,l);

	// load name and ask for ptr
	n = readName();
	if(getRoot()->getType() == NUM_WORLD)
	{
		w = (world*)getRoot();
		viewptr = w->getView(n);
	}

	anim::load(m,l - (m->tell() - pos));
	dim::load(m,l - (m->tell() - pos));

	return 0;
}

double	camera::volume(int)
{
	return 0;
}



