/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** csg.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "csg.h" 
#include "view.h"

csg::csg(base *p,const char *n,CSG_TYPE ct,texture *t) :
	csgobj(p,n,t)
{
	numtype = NUM_CSG;
	csgtype = ct;

	csglist.setErrorValue(NULL);

	if(parent) addToParent(parent);
}

csg::csg(base *p,const char *n,CSG_TYPE ct,Vector3 &vs,Vector3 &vr,Vector3 &vt) : 
	csgobj(p,n,vs,vr,vt) 
{ 
	numtype = NUM_CSG; 
	csgtype = ct; 

	csglist.setErrorValue(NULL);

	if(parent) addToParent(parent);
}

csg::csg(base *p,const char *n,CSG_TYPE ct,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) : 
	csgobj(p,n,t,vs,vr,vt) 
{ 
	numtype = NUM_CSG; 
	csgtype = ct; 

	csglist.setErrorValue(NULL);

	if(parent) addToParent(parent);
}

csg::csg(base *p,csg *cc) : 
	csgobj(p,(csgobj*)cc) 
{
	int	t;

	numtype = NUM_CSG; 
	csgtype = cc->csgtype; 

	csglist.setErrorValue(NULL);
	for(t = 0;t < cc->csglist.length();t++)
	{
		// create a copy
		cc->csglist[t]->copy(this);
	}

	if(parent) addToParent(parent);
}

csg::~csg()
{
	csgobj	*c;

	for(c = csglist.getFirst();c != NULL;c = ++csglist)
	{ 
		delete c;
	}
	removeFromParent();
}

base	*csg::copy(base *p)
{
	return new csg(p,this);
}

void	csg::getChildren(base ***b)
{
	int	t;
	base	**bt;

	*b = 0;
	bt = (base**)malloc(sizeof(void*) * (csglist.length() + 1));
	if(!bt) return;

	for(t = 0;t < csglist.length();t++)
		bt[t] = csglist[t];
	bt[t] = 0;
	*b = bt;
}

void	csg::dumpNames(int tab,int tabsize)
{
	csgobj	*b;

	printTab(stdout,tab);
	printf("csg: %s  ",name);

	switch(getCSGType()) 
	{ 
		case UNION: 
			printf("(union)\n"); 
		break; 
		case MERGE: 
			printf("(merge)\n"); 
		break; 
		case DIFFERENCE: 
			printf("(difference)\n"); 
		break; 
		case INTERSECTION: 
			printf("(intersection)\n"); 
		break; 
		case INVERT:  
			printf("(invert)\n");  
		break;  
	} 
	for(b = csglist.getFirst();b != NULL;b = ++csglist)  
	{  
		b->dumpNames(tab + tabsize,tabsize); 
		csglist.find(b);
	}  
}

int	csg::exportPOV(FILE *fp,int tab,int tabsize,int anim) 
{ 
	int	i;

	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = csg ");

	switch(getCSGType())
	{
		case UNION:
			fprintf(fp,"(union)\n");
		break;
		case MERGE:
			fprintf(fp,"(merge)\n");
		break;
		case DIFFERENCE:
			fprintf(fp,"(difference)\n");
		break;
		case INTERSECTION:
			fprintf(fp,"(intersection)\n");
		break;
		case INVERT: 
			fprintf(fp,"(invert)\n"); 
		break; 
	}

	printTab(fp,tab);
	switch(getCSGType())
	{
		case MERGE:
			fprintf(fp,"merge\n");
		break;
		case DIFFERENCE:
			fprintf(fp,"difference\n");
		break;
		case INTERSECTION:
			fprintf(fp,"intersection\n");
		break;
		case INVERT: 
			fprintf(fp,"invert\n"); 
		break; 
		case UNION:
		default:
			fprintf(fp,"union\n");
		break;
	}

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for(i = 0;i < csglist.length();i++)
	{
		csglist[i]->exportPOV(fp,tab + tabsize,tabsize,anim);
		if(getCSGType() == INVERT) break;
	}

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize,anim);

	dim::exportPOV(fp,tab + tabsize,tabsize,anim);

	if(isFlag(HOLLOW_ON))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow on\n");
	}
	else if(isFlag(HOLLOW_OFF))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow off\n");
	}
	
	
	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	csg::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	csg::removeFromParent()
{
	if(!parent) return -2;
	return parent->removeChild(this);
}

int	csg::addChild(csgobj *child)
{
	if(!child) return -1;
	return csglist += child;
}

int	csg::addChild(blob *child) 
{ 
	if(!child) return -1; 
	return csglist += child; 
} 

int	csg::addChild(blobobj *child) 
{ 
	if(!child) return -1; 
	return csglist += child; 
} 

int	csg::removeChild(csgobj *child) 
{ 
	if(!child) return -1;
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

int	csg::removeChild(blob *child) 
{ 
	if(!child) return -1; 
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

int	csg::removeChild(blobobj *child) 
{ 
	if(!child) return -1; 
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

base	*csg::searchName(const char *n)
{
	const char	*c;
	base		*b;
	int		i;

	if(n == 0) return 0;

	c = getName();
	if(c != 0 && strcmp(c,n) == 0)
		return this;

	for(i = 0;i < csglist.length();i++)
	{
		if((b = csglist[i]->searchName(n))) return b;
	}

	return 0;
}

int	csg::existsName(const char *n) 
{ 
	csgobj		*d; 
	const char	*c; 
 
	if(n == 0) return -1; 
 
	c = getName(); 
	if(c != 0 && strcmp(c,n) == 0) 
		return !0; 
 
	for(d = csglist.getFirst();d != 0;d = ++csglist) 
	{ 
		if(d->existsName(n)) return !0; 
		csglist.find(d);
	} 
 
	return 0; 
} 
 
int	csg::save(media *m)  
{  
	int	i;

	setMedia(m);
	writeChunk("CSG ");
	writeNameChunk(name);

	saveFlags(m);

	m->write(&csgtype,1);

	for(i = 0;i < csglist.length();i++) 
	{ 
		csglist[i]->save(m); 
	} 

	anim::save(m); 
	dim::save(m); 
	saveTexture(m);

	writeChunkLen();

	return 0; 
} 

int	csg::load(media *m,int l)
{
	int	pos = m->tell();
	base	*b;

	csgtype = UNION;

	loadFlags(m,l);

	m->read(&csgtype,1);
	while((int)m->tell() < pos + l - 9 * (int)sizeof(double))
	{
		b = parse(m);
		if(b)
		{
			b->addToParent(this);
			b->setParent(this);
		}
		else break;
	}

	anim::load(m,l - (m->tell() - pos));
	dim::load(m,l - (m->tell() - pos));

 	if(l - (m->tell() - pos) > 0)
	{
		loadTexture(m,l - (m->tell() - pos));
	}

	return 0;
}

int	csg::draw(view *v,Matrix44 m,int anim)
{
	csgobj		*d;
	int		t;
	Vector3		vec(0,0,0);

	if(isFlag(HIDE)) return 0;

	if(v == 0) return -1; 
 
	dimMatrix(m,anim);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCross(vec,m,anim);

	if(isFlag(DRAW_BOUNDINGBOX))
		drawBB(v,m,anim);
	else
		for(t = 0;t < csglist.length();t++) 
		{ 
			d = csglist[t];
			d->draw(v,m,anim); 
		} 

 	if(this == v->getSelected()) v->setDrawSelected(0);

	if(isFlag(DRAW_AXIS))
		v->drawAxis(m,anim);

	drawDragvectors(v,m,anim);

	return 0; 
} 
 
int	csg::calculate(int anim)
{
	csgobj		*d;
	int		t;
	Vector4		smin,smax;
	Matrix44	m;

	vmin = Vector3(1e100,1e100,1e100);
	vmax = Vector3(-1e100,-1e100,-1e100);

	for(t = 0;t < csglist.length();t++)
	{
		d = csglist[t];
		m.unify();
		d->dimMatrix(m,anim);
		d->calculate(anim);
		smin = Vector4(d->min(),1);
		smax = Vector4(d->max(),1);
		smin *= m;
		smax *= m;
		vmin[0] = MIN(vmin[0],smin[0]); 
		vmin[1] = MIN(vmin[1],smin[1]); 
		vmin[2] = MIN(vmin[2],smin[2]); 
		vmax[0] = MAX(vmax[0],smax[0]); 
		vmax[1] = MAX(vmax[1],smax[1]); 
		vmax[2] = MAX(vmax[2],smax[2]); 
	}

	return 0;
}

double	csg::volume(int anim)
{
	// this function ist extreme complexe
	return 1;
}




