/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** lightpoint.h
*/
#ifndef __LIGHTPOINT_H__
#define __LIGHTPOINT_H__


#include <classes.h>


class lightpoint : public lightobj
{
protected:
	double	r,g,b;
	double	fade_distance;
	double	fade_power;
	int	atmos_attenuation;

public:
	lightpoint(base *p=0,char *n="Untitled");
	lightpoint(base *p,char *n,Vector3&,Vector3&,Vector3&);
	lightpoint(base *p,lightpoint *lc);
	~lightpoint();

	void		setColor(double, double, double);
	void		setColor(Vector3);
	void		setFadeDistance(double);
	void		setFadePower(double);
	void		setAtmosAtt(int);

	Vector3		getColor();
	double		getFadeDistance();
	double		getFadePower();
	int		getAtmosAtt();

	virtual int	addToParent(base *p);
	virtual int	removeFromParent(); 

	virtual base	*copy(base*);

	virtual int	exportPOV(FILE *f,int tab,int tabsize,int anim = 0);
	virtual void	dumpNames(int tab,int tabsize);
	
	virtual int	save(media *);
	virtual int	load(media *, int);

	virtual int	draw(view*,Matrix44,int);
	virtual int	calculate(int);
	virtual int	isFinite();
};

#endif	
