/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** refptr.cpp
*/
#include <stdio.h>
#include <stdlib.h>

#include "refptr.h"
#include "view.h"

refptr::refptr(base *p,const char *n,texture *t) :
	atom(p,n,t)
{
	numtype = NUM_REFPTR;
	refp = 0;
	tmpname = 0;

	if(parent)
		addToParent(parent);
}

refptr::refptr(base *p,const char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	atom(p,n,vs,vr,vt)
{
	numtype = NUM_REFPTR;
	refp = 0;
	tmpname = 0;

	if(parent)
		addToParent(parent);
}

refptr::refptr(base *p,const char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	atom(p,n,t,vs,vr,vt)
{
	numtype = NUM_REFPTR;
	refp = 0;
	tmpname = 0;

	if(parent)
		addToParent(parent);
}

refptr::refptr(base *p,refptr *rc) :
	atom(p,(atom*)rc)
{
	numtype = NUM_REFPTR;
	refp = rc->refp;
	tmpname = rc->tmpname;

	if(parent)
		addToParent(parent);
}

refptr::~refptr()
{
	removeFromParent();
}

base	*refptr::copy(base *p)
{
	return new refptr(p,this);
}

int	refptr::addToParent(base *b)
{
	if(!b) return -2;

	parent = b;
	return b->addChild(this);
}

int	refptr::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

int	refptr::addChild(ref *r)
{
	if(!r) return -2;

	refp = r;

	return 0;
}

void	refptr::getChildren(base ***b)
{
	base	**bt;

	*b = NULL;
	bt = (base**)malloc(sizeof(void*) * 2);
	if(!bt) return;

	bt[0] = 0; //refp;
	bt[1] = 0;
	*b = bt;
}

int	refptr::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	if(isFlag(NO_EXPORT)) return 0;

	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(refp)
		{
			if(tmpname) free(tmpname);
			tmpname = 0;
		}
	}
	if(!refp && !tmpname) return -1;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = refptr\n");

	printTab(fp,tab);
	fprintf(fp,"object\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	if(refp)
		fprintf(fp,"%s\n",refp->getName());
	else if(tmpname)
		fprintf(fp,"%s\n",tmpname);

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize,anim);

	dim::exportPOV(fp,tab + tabsize,tabsize,anim);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

void	refptr::dumpNames(int tab,int tabsize)
{
	printTab(stdout,tab);
	printf("refptr: %s\n",name);

	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return;
		if(tmpname) free(tmpname);
		tmpname = 0;
	}
	refp->dumpNames(tab + tabsize,tabsize);
}

int	refptr::save(media *m)
{
	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return -1;
		if(tmpname) free(tmpname);
		tmpname = 0;
	}

	setMedia(m);
	writeChunk("REFP");
	writeNameChunk(name);

	saveFlags(m);

	writeName(refp->getName());
	anim::save(m);
	dim::save(m);
	saveTexture(m);
	writeChunkLen();

	return 0;
}

int	refptr::load(media *m,int l)
{
	int	pos = m->tell();

	loadFlags(m,l);

	tmpname = readName();

	anim::load(m,l - (m->tell() - pos));
	dim::load(m,l - (m->tell() - pos));

	if(l > (m->tell() - pos))
	{
		loadTexture(m,l - (m->tell() - pos));
	}

	return 0;
}

base	*refptr::getPTR()
{
	if(!refp && tmpname)
	{
		base	*root;

		root = getRoot();
		refp = (ref*)(root->searchName(tmpname));
		if(refp && tmpname) free(tmpname);
	}
		
	return refp;
}

const char	*refptr::getPTRName()
{
	if(refp) return refp->getName();
	if(tmpname) return tmpname;

	return 0;
}

int	refptr::draw(view *v,Matrix44 m,int anim)
{
	if(isFlag(HIDE)) return 0;

	dimMatrix(m,anim);

	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return -2;
		if(tmpname) free(tmpname);
		tmpname = 0;
	}

	if(this == v->getSelected()) v->setDrawSelected(1);

	if(isFlag(DRAW_BOUNDINGBOX))
		calculate(anim);
	refp->drawRef(v,m,anim,isFlag(DRAW_BOUNDINGBOX));

	if(this == v->getSelected()) v->setDrawSelected(0);

	if(isFlag(DRAW_AXIS))
		v->drawAxis(m,anim);

	return 0;
}

int	refptr::calculate(int anim)
{
	Vector4		smin,smax;

	vmin = Vector3(1e100,1e100,1e100);
	vmax = Vector3(-1e100,-1e100,-1e100);

	refp->calculate(anim);
	smin = Vector4(refp->min(),1);
	smax = Vector4(refp->max(),1);
	vmin[0] = MIN(vmin[0],smin[0]); 
	vmin[1] = MIN(vmin[1],smin[1]); 
	vmin[2] = MIN(vmin[2],smin[2]); 
	vmax[0] = MAX(vmax[0],smax[0]); 
	vmax[1] = MAX(vmax[1],smax[1]); 
	vmax[2] = MAX(vmax[2],smax[2]); 

	return 0;
}

double	refptr::volume(int anim)
{
	return 0;//refp->volume(anim);
}



