/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** view.h
*/
#ifndef __VIEW_H__
#define __VIEW_H__


#include <matmath.h>
#include <chunk.h>

#include <classes.h>

#include "world.h"

#define EPSILON	1e-100

class camera;

class view : public dim
{
public:
	typedef enum
	{
		PERSPECTIVE = 1,
		PARALLEL_XY,
		PARALLEL_XZ,
		PARALLEL_ZY,
	}
	PROJECTION;

protected:
	camera		*cameraptr;

	Matrix44	mview,mscreen,mcamera;
	double		fov,aspect_ratio;
	int		w,h;

	int		projmode;	

	world		*worldptr;
	base		*selectedptr;
	int		drawselected;

public:
	view(world*,const char *n);
	view(world*,view *v);
	virtual		~view();

	int		addToParent(base *p);
	int		removeFromParent();

	base		*copy(base*);

	void		dumpNames(int,int);
	
	void		take(view &v);
	void		take(view *v);

	void		setCamera(camera *c);
	camera		*getCamera();

	int		setWorld(world *wp);

	int		setFOV(double d);
	int		setAspectRatio(double d);
	int		setScreenSize(int,int);

	int		project(Vector3 v,Vector2 &xy,Matrix44 m,int);
	int		reproject(Vector2 xy,Vector3 &v,Matrix44 m,int);


	void		setProjectionMode(int pm);
	int		projectionMode();

	void		setSelected(base *bp);
	base		*getSelected();
	void		setDrawSelected(int sel);

	virtual int	drawLine(Vector3,Vector3,Matrix44,int);
	virtual int	drawCross(Vector3,Matrix44,int);
	virtual int	drawTriangle(Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawTrapezium(Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawCircle(Vector3,Vector3,Vector3,Matrix44,int);

	virtual int	drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);
	virtual int	drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);

	virtual int	drawBlobSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	virtual int	drawBlobCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);

	virtual int	drawSymbol(Vector3,const char*,Matrix44,int);

	virtual int	drawAxis(Matrix44,int);
	virtual int	drawDragvector(Matrix44,Vector3,Vector3,int);

	int		exportPOV(FILE*,int,int);
	int		exportPOV(FILE*,int,int,int);

	int		save(media*/*,int*/);
	int		load(media*,int/*,int*/);

	int		calculate(int);
	double		volume(int);
	int		draw(view*,Matrix44,int);
	
protected:

	void	createView(int);
	void	createScreen(int w,int h);
	void	calcVectors(int);
};


#endif

