/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** color.cpp
*/

#include <stdlib.h>
#include <string.h>

#include "color.h"

 char *CcolorPic1[] = {
		"15 13 3 1",
		" 	c None",
		".	c #000000",
		"+	c #FFFFFF",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++"};
color::color(textureBase *p):textureBase(COLOR,p)
{
int i;
	
	r = 0;
	g = 0;
	b = 0;
	t = 0;
	f=0;
	setName("Color");
	setSubItems(false);
	for (i=0i;i<17;i++) PicBuf[i]=NULL;
	updateInfo();


}

void color::updateInfo()
{
char *buffer=(char *)malloc(512);
        sprintf(buffer,"R=%d G=%d B=%d T=%d",(int)(red()*255),(int)(green()*255),(int)(blue()*255),(int)(transparency()*255));
	setInfo(buffer);
	free(buffer);
}

const char **color::getXPM()
{
int r1=(int)(red()*255);
int g1=(int)(green()*255);
int b1=(int)(blue()*255);

int r2=255-(int)(transparency()*255 );
int g2=255-(int)(transparency()*255 );
int b2=255-(int)(transparency()*255 );


char *buffer1,*buffer2;
int i;
	

	buffer1=(char *)malloc(128);
	buffer2=(char *)malloc(128);
	sprintf(buffer1,"+\tc #%02x%02x%02x",r1,g1,b1);
	sprintf(buffer2,".\tc #%02x%02x%02x",r2,g2,b2);

	for (i=0i;i<17;i++) if (PicBuf[i]) delete PicBuf[i];
	
	for (i=0;i<17;i++) PicBuf[i]=strdup(CcolorPic1[i]);
	strncpy(PicBuf[3],buffer1,11); //Color
	strncpy(PicBuf[2],buffer2,11); //Transparenz

	free(buffer1);
	free(buffer2);

	return (const char **)&PicBuf;
}

bool color::isEqual(textureBase *tb)
{
color *c1=(color *)tb;
#ifdef DEBUG
	printf("Comparing Colors...\n");
#endif
	if (tb->getType()!=COLOR) return false;
	if (c1) {
		if ((c1->red()==red() )&&
		(c1->green()==green() )&&
		(c1->blue()==blue() )&&
		(c1->filter()==filter() )&&
		(textureBase::isEqual(tb)==true) &&
		(c1->transparency()==transparency() )) {
#ifdef DEBUG
	printf("Compared Colors  found it !...\n");
#endif
			return true;
		}
	}
	return false;	
}

bool color::canAdd(textureBase *tb)
{
int t=tb->getType();
	if (t==COLOR) return true;
	if (t==COLORENTRY) return true;
	return false;
}

void color::add(textureBase *tb)
{
int t;
	if(!tb) return;
	if (canAdd(tb)==false) return;

	t=tb->getType();
	if (t==COLOR) {
		color *c=(color *)tb;
		setRed(c->red());
		setGreen(c->green());
		setBlue(c->blue());
		setTransparency(c->transparency());
		updateInfo();
	}
	if (t==COLORENTRY) {
		colorEntry *c=(colorEntry *)tb;
		setRed(c->getRed());
		setGreen(c->getGreen());
		setBlue(c->getBlue());
		setTransparency(c->getTransparency());
		setFilter(c->getFilter());
		updateInfo();
	}
}

color::~color()
{
int i;
	for (i=0i;i<17;i++) if (PicBuf[i]) delete PicBuf[i];
}

double	color::red()
{
	
	return r;
}

double	color::green()
{
	
	return g;
}

double	color::blue()
{
	
	return b;
}

double	color::transparency()
{
	
	return t;
}

double	color::filter()
{
	return f;
}


void	color::setRed(double rr)
{
	r = rr;
	updateInfo();
}

void	color::setGreen(double gg)
{
	g = gg;
	updateInfo();
}

void	color::setFilter(double ff)
{
	f = ff;
	updateInfo();
}


void	color::setBlue(double bb)
{
	b = bb;
	updateInfo();
}

void	color::setTransparency(double tt)
{
	t = tt;
	updateInfo();
}


int	color::save(media *m)
{
chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving Color\n");
	#endif

	setMedia(m);

	writeChunk("COLR");

	textureBase::save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");
		writeDouble(r);
		writeDouble(g);
		writeDouble(b);
		writeDouble(t);
		writeDouble(f);
	ch.writeChunkLen();

	writeChunkLen();

	#ifdef DEBUG
		printf("Color saved\n");
	#endif
	return 0;
}

int	color::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	#ifdef DEBUG
		printf("Loading Color\n");
	#endif

	if(!m) return -1;
	setMedia(m);	

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			r=readDouble();
			g=readDouble();
			b=readDouble();
			t=readDouble();
			f=readDouble();
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("Color loaded\n");
	#endif
	updateInfo();
	return 0;
}

int		color::exportPOV(FILE *fp,int tab,int tabsize,int a,bool x)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting Color (POV)\n");
	#endif
	printTab(fp,tab);
		fprintf(fp,"color rgbt<%g,%g,%g,%g>  //%s\n",red(),green(),blue(),transparency(),getName());
	
	#ifdef DEBUG
		printf("Color exported (POV) saved\n");
	#endif
	return 0;
}

