/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlist.h
*/
#ifndef __COLORLIST_H__
#define __COLORLIST_H__

#include "texturebase.h"
#include <list.h>
#include <string.h>
#include "color.h"


class colorList :public textureBase
{

	
public:
	enum FUNCTION
	{	Brick,
		Checker,
		Hexagon,
		NFunctions
	};

	colorList(textureBase *p=NULL);
	~colorList();

	bool isEqual(textureBase *);

	void 	setColorListFunction(FUNCTION f);
	int 	getColorListFunction();
	
	char 	*getColorListFunctionName();
	char 	*getColorListFunctionNameList(int);

	textureBase	*getFirstElement();
	textureBase	*getNextElement();
	void	addElement(textureBase *,textureBase *a=NULL);

	void	setActive(bool a,textureBase *tb);

	bool	canAdd(textureBase *);
	void	add(textureBase *);



	void	remove(textureBase *);

	int	load(media*,int);
	int	save(media*);
	int	exportPOV(FILE*,int,int,int,bool);

protected:
	list<textureBase *> elements;
	int elementnr;
	FUNCTION	fn;

	void updateInfo();	
};


#endif


