/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** interior.h
*/
#ifndef __interior_H__
#define __interior_H__

#include "texturebase.h"
#include "color.h"
#include "transformations.h"
#include "turbulence.h"

#include "density.h"

class interior : public textureBase
{
protected:

	color *absorption,*emission,*scatter;
	int scattertype;
	double scatterecc,scatterext;
	double samplemin,samplemax;
	int	intervals;
	double ratio,confidence,variance;

	Transformations transform;
	Turbulence	turbulence;

	list<textureBase *>	elements;
	int elementnr;

public:

	interior(textureBase *p=NULL);
	~interior();

	bool	isExportable();

	Transformations *getTransformations();
	Turbulence *getTurbulence();

	void 	setRatio(double);
	double getRatio();

	void 	setConfidence(double);
	double    getConfidence();

	void	setVariance(double);
	double	getVariance();

	void	setIntervals(int);
	int	getIntervals();

	color *getAbsorption();
	void setAbsorption(color *);

	color *getEmission();
	void setEmission(color *);
	
	color *getScatter();
	void setScatter(color *);

	int getScatterType();
	void setScatterType(int);

	double getScatterECC();
	void setScatterECC(double);

	double getScatterEXT();
	void setScatterEXT(double);

	double getSampleMax();
	void setSampleMax(double);

	double getSampleMin();
	void setSampleMin(double);

	bool	canAdd(textureBase *);
	void	add(textureBase *);

	void 	remove(textureBase *);
	
	void	setActive(bool a,textureBase *tb);


	textureBase	*getFirstElement();
	textureBase	*getNextElement();
	void	addElement(textureBase *,textureBase *a=NULL);


	bool	isEqual(textureBase *);

	int		load(media*,int);
	int		save(media*);

	int		exportPOV(FILE*,int,int,int,bool);
};


#endif