/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebase.h
*/
#ifndef __TEXTUREBASE_H__
#define __TEXTUREBASE_H__

#include <misc.h>
#include <list.h>
#include <chunk.h>
#include <stdio.h>
#include <string.h>


enum	ttyp 	{
			COLOR,
			COLORMAP,
			COLORLIST,
			PIGMENTMAP,
			PIGMENTLIST,
			IMAGEMAP,
			PIGMENT,
			BUMPMAP,
			NORMAL,
			TEXTURE,
			TEXTURELIBRARY,
			FINISH,
			MEDIA,
			INTERIOR,
			TEXTUREBOOK,
			BITMAPMODIFIER,
			TRANSFORMATIONS,
			MAPMODIFIER,
			TURBULENCEMODIFIER,
			PATTERNMODIFIER,
			COLORENTRY,
			DENSITY,
		        NORMALMAP,
			NORMALLIST,
			SLOPEENTRY,
			SLOPEMAP
		};


class textureBase:public chunk
{
protected:

	char 	*name;
	char	*ptr;  //Macroname
	char	*info;
	
	char *author;
	char *description;
	int  flags;
	

	bool subitems;
	bool Active;

	bool open;   // nur fr die GUI !!!
	bool selected;  //dito !!!

	ttyp	typ;
	int locks;

	textureBase *parent;

public:

	textureBase(ttyp,textureBase *p=0);	
	virtual ~textureBase();

	textureBase *getElementByType(ttyp t);

	void		setSelected(bool a);
	bool 		isSelected();
	void 		setOpen(bool);
	bool		isOpen();

	void		alloc();
	bool		isLocked();
        void		deAlloc();
	
	void 		setName(const char *);
	const char	*getName();

	const char	*getPath();

	const char	*getInfo();
	void 		setInfo(char *);

	virtual const char 	**getXPM();
	

	void		setPtr(const char *);
	const char	*getPtr();
	
	void setParent(textureBase *);
	textureBase *getParent();

	ttyp	getType();

	bool		active();
	virtual void	setActive(bool,textureBase *tb=NULL);

	bool	hasSubItems();
	void 	setSubItems(bool);

	virtual textureBase* getFirstElement();
	virtual textureBase* getNextElement();
	virtual void addElement(textureBase *what, textureBase *where=NULL);

	virtual void remove(textureBase *);

	virtual bool canAdd(textureBase *);
	virtual void add(textureBase *element);

	virtual	bool isEqual(textureBase*);
	
	virtual int save(media*);
	virtual int load(media*,int);

	virtual int exportPOV(FILE *f,int a, int b, int c=0,bool d=false);

};

#endif
