/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mainwin.cpp
*/


#include <version.h>

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kstatusbar.h>

#include <qkeycode.h>

#include <misc.h>

#include "../dialogs/dialogs.h"
#include "../dialogs/preferencedialog.h"


#define stloc(a)	(klocale->translate(a))

#include "mainwin.h"
#include "mainwin.moc"

#include "../texture/textureview.h"

#include "icons/toolbar/fov.xpm"
#include "icons/toolbar/moveview.xpm"
#include "icons/toolbar/rotateview.xpm"

#include "icons/toolbar/scale.xpm"
#include "icons/toolbar/translate.xpm"
#include "icons/toolbar/rotate.xpm"

#include "icons/toolbar/3dview.xpm"
#include "icons/toolbar/xyview.xpm"
#include "icons/toolbar/xzview.xpm"
#include "icons/toolbar/zyview.xpm"

#include "icons/toolbar/axe-x.xpm"
#include "icons/toolbar/axe-y.xpm"
#include "icons/toolbar/axe-z.xpm"

#include "icons/toolbar/render.xpm"
#include "icons/toolbar/renderlow.xpm"

#include "icons/toolbar/inserttexture.xpm"
#include "icons/toolbar/newtexture.xpm"
#include "icons/toolbar/newtexturefolder.xpm"
#include "icons/toolbar/newtexturewindow.xpm"
#include "icons/toolbar/savetexturelib.xpm"
#include "icons/toolbar/newpigment.xpm"
#include "icons/toolbar/newnormal.xpm"
#include "icons/toolbar/newfinish.xpm"
#include "icons/toolbar/newinterior.xpm"


#include "icons/menu/fileopen2.xpm"
#include "icons/menu/filefloppy.xpm"
#include "icons/menu/filenew.xpm"

#include "icons/tree/obj.xpm"
#include "icons/tree/csg.xpm"
#include "icons/tree/blob.xpm"
#include "icons/tree/box.xpm"
#include "icons/tree/sphere.xpm"
#include "icons/tree/cylinder.xpm"
#include "icons/tree/cone.xpm"
#include "icons/tree/torus.xpm"
#include "icons/tree/mesh.xpm"
#include "icons/tree/triangle.xpm"
#include "icons/tree/text.xpm"
//#include "icons/tree/script.xpm"
#include "icons/tree/heightfield.xpm"
#include "icons/tree/plane.xpm"
#include "icons/tree/ref.xpm"
#include "icons/tree/refptr.xpm"
#include "icons/tree/lightpoint.xpm"
#include "icons/tree/spotlight.xpm"
#include "icons/tree/arealight.xpm"
#include "icons/tree/camera2.xpm"


MainWin::MainWin(char *name) :
//	KTopLevelWidget(name)
	KTMainWindow(name)
{
	Preferences	pref;

	stbar = 0;

	createMenu();	// !! Menus *vor* den Widgets generieren !!
	createWidgets();
	
	createStatusBar("Welcome to K4DE");
	
	changed = 0;
	projectname = 0;

	newClicked();

	lastread = pref.getPath(pref.getDataPath());
	lastwrite = pref.getPath(pref.getDataPath());
}

MainWin::~MainWin()
{
	if(projectname)
		free(projectname);
}

void	MainWin::resizedView(int w,int h)
{
	QString		str,sx,sy;
	
//	sx.setNum(viewwidget->width());
//	sy.setNum(viewwidget->height());
	sx.setNum(w);
	sy.setNum(h);
	
	str = "View " + sx + " x " + sy;
	stbar->changeItem(str,0);
}

void	MainWin::displayMessage(QString s)
{
	stbar->changeItem(s,1);
}

void	MainWin::createStatusBar(QString message)
{
	QString		str,sx,sy;
	
	if(!stbar)
	{
		stbar = new KStatusBar(this);
		setStatusBar(stbar);

		stbar->setInsertOrder(KStatusBar::RightToLeft);
	
		str = "View 8888 x 8888";
		stbar->insertItem(str,0);
		stbar->insertItem(message,1);
	}

	sx.setNum(viewwidget->width());
	sy.setNum(viewwidget->height());
	
	str = "View " + sx + " x " + sy;
	stbar->changeItem(str,0);
	stbar->changeItem(message,1);
}

void	MainWin::createWindowTitle()
{
	QString		title;

	title = PROGNAME " V" VERSION "  [";
		
	if(projectname)
  		title += projectname;
	else  		
  		title += "Untitled";

	title += "]";
			
	setCaption(title);
}

void	MainWin::createWidgets()
{
	vpanner = new KNewPanner(this,0,KNewPanner::Horizontal,KNewPanner::Percent,40);
	hpanner = new KNewPanner(vpanner,0,KNewPanner::Vertical,KNewPanner::Absolute,300);
	vpanner2 = new KNewPanner(vpanner,0,KNewPanner::Horizontal,KNewPanner::Percent,99);
        vpanner2->setEnabled(0);

	worldtree = new WorldTree(hpanner);
	viewwidget = new ViewWidget(hpanner,"View",0);
//	viewwidget = 0;

	tview = new TextureView(vpanner2,"Textures");

	MPigment = new MPopupMenu;
	MPigment->insertItem("Pigment",tview,SLOT(newPigmentElementPig()),0);
	MPigment->insertSeparator();
	MPigment->insertItem("Color",tview,SLOT(newPigmentElementCol()),1);
	MPigment->insertItem("Image",tview,SLOT(newPigmentElementImg()),2);
	MPigment->insertItem("Colormap",tview,SLOT(newPigmentElementCma()),3);
	MPigment->insertItem("Colorlist",tview,SLOT(newPigmentElementCli()),4);
	//MPigment->insertItem("Pigmentlist"),tview,SLOT(newPigmentElementPli()),5);
	//MPigment->insertItem("Pigmentmap"),tview,SLOT(newPigmentElementPma()),6);

	MNormal = new MPopupMenu;
	MNormal->insertItem("Normal",tview,SLOT(newNormalElementNor()),0);
	MNormal->insertSeparator();
	MNormal->insertItem("Bumpmap",tview,SLOT(newNormalElementBmp()),1);
	MNormal->insertItem("Slopemap",tview,SLOT(newNormalElementSlp()),2);

	MFinish = new MPopupMenu;
	MFinish->insertItem("Finish-Parameter",tview,SLOT(newFinishElement()),0);


	MInterior = new MPopupMenu;
	MInterior->insertItem("Interior",tview,SLOT(newInteriorElementInt()),0);
	MInterior->insertSeparator();
	MInterior->insertItem("Density",tview,SLOT(newInteriorElementDen()),1);


	connect(tview,SIGNAL(message(QString)),this,SLOT(displayMessage(QString) ) );
	animwidget = new AnimControlWidget(vpanner2);
	animwidget->hide();

	hpanner->activate(worldtree,viewwidget);
	vpanner2->activate(tview,animwidget);
	vpanner->activate(hpanner,vpanner2);

	setView(vpanner);

	connect(worldtree,SIGNAL(changeWorld(world*)),viewwidget,SLOT(setWorld(world*)));
	connect(worldtree,SIGNAL(changeWorld(world*)),animwidget,SLOT(setWorld(world*)));
	connect(animwidget,SIGNAL(changeWorld(world*)),viewwidget,SLOT(setWorld(world*)));
	connect(animwidget,SIGNAL(changeWorld(world*)),worldtree,SLOT(setWorld(world*)));
	connect(animwidget,SIGNAL(exportPOVanim(const char*)),this,SLOT(exportPOVanim(const char*)));
	connect(worldtree,SIGNAL(redraw()),viewwidget,SLOT(draw()));
	connect(animwidget,SIGNAL(drawanim()),viewwidget,SLOT(drawanim()));
	connect(viewwidget,SIGNAL(exportPOV(const char*)),this,SLOT(exportPOV(const char*)));
	connect(viewwidget,SIGNAL(resizedView(int,int)),this,SLOT(resizedView(int,int)));
	connect(viewwidget,SIGNAL(report(QString)),this,SLOT(displayMessage(QString)));

	connect(worldtree,SIGNAL(changeWorld(world*)),tview,SLOT(setWorld(world*)));
	connect(animwidget,SIGNAL(changeWorld(world*)),tview,SLOT(setWorld(world*)));

	connect(tview,SIGNAL(changedTexture(texture*)),worldtree,SLOT(changeTexture(texture*)));

	mainbar = new KToolBar(this);

	mainbar->insertButton(QPixmap((const char**)filenew_xpm),1,SIGNAL(clicked()),this,SLOT(newClicked()),true,stloc("New"));
	mainbar->insertButton(QPixmap((const char**)fileopen_xpm),2,SIGNAL(clicked()),this,SLOT(openClicked()),true,stloc("Open"));
	mainbar->insertButton(QPixmap((const char**)filefloppy_xpm),3,SIGNAL(clicked()),this,SLOT(saveClicked()),true,stloc("Save"));
	mainbar->insertSeparator();
	mainbar->insertSeparator();
       	mainbar->insertButton(QPixmap((const char**)obj_xpm),4,Mobjects,true,"Objects");
	mainbar->insertSeparator();
	mainbar->insertSeparator();



        tbview = new KToolBar(this);
	tbview->insertButton(QPixmap((const char**)fov_xpm),1,true,stloc("Change camera focus"));
	tbview->insertButton(QPixmap((const char**)moveview_xpm),2,true,stloc("Change camera position"));
	tbview->insertButton(QPixmap((const char**)rotateview_xpm),3,true,stloc("Change camera angle"));
	tbview->setToggle(1);
	tbview->setToggle(2);
	tbview->setToggle(3);
	tbview->insertButton(QPixmap((const char**)scale_xpm),4,true,stloc("Change object size"));
	tbview->insertButton(QPixmap((const char**)translate_xpm),5,true,stloc("Change object position"));
	tbview->insertButton(QPixmap((const char**)rotate_xpm),6,true,stloc("Change object angle"));
	tbview->setToggle(4);
	tbview->setToggle(5);
	tbview->setToggle(6);
	tbview->insertSeparator();
	tbview->insertButton(QPixmap((const char**)_3dview_xpm),7,true,stloc("Change camera to 3d-projection"));
	tbview->insertButton(QPixmap((const char**)xyview_xpm),8,true,stloc("Change camera to xy-projection"));
	tbview->insertButton(QPixmap((const char**)xzview_xpm),9,true,stloc("Change camera to xz-projection"));
	tbview->insertButton(QPixmap((const char**)zyview_xpm),10,true,stloc("Change camera to zy-projection"));
	tbview->setToggle(7);
	tbview->setToggle(8);
	tbview->setToggle(9);
	tbview->setToggle(10);
	tbview->insertSeparator();
	tbview->insertButton(QPixmap((const char**)axe_x_xpm),11,true,stloc("Change at x-axe"));
	tbview->insertButton(QPixmap((const char**)axe_y_xpm),12,true,stloc("Change at y-axe"));
	tbview->insertButton(QPixmap((const char**)axe_z_xpm),13,true,stloc("Change at z-axe"));
	tbview->setToggle(11);
	tbview->setToggle(12);
	tbview->setToggle(13);
	tbview->insertSeparator();
	tbview->insertButton(QPixmap((const char**)render_xpm),14,true,stloc("Render the view"));
	tbview->insertButton(QPixmap((const char**)renderlow_xpm),15,true,stloc("Render the view (low quality)"));
	tbview->setButton(1,true);
	tbview->setButton(7,true);
	tbview->setButton(11,true);
	tbview->setButton(12,true);
	tbview->setButton(13,true);

	tbtxtview=new KToolBar(this);

	tbtxtview->insertButton(QPixmap((const char**)newtexturewindow_xpm),3,true,stloc("Open new Texture-Library-Window"));
	tbtxtview->insertSeparator();
	tbtxtview->insertButton(QPixmap((const char**)inserttexture_xpm),2,true,stloc("Insert Texture-Library"));
	tbtxtview->insertButton(QPixmap((const char**)savetexturelib_xpm),4,true,stloc("Save Texture-Library"));
	tbtxtview->insertSeparator();
	tbtxtview->insertButton(QPixmap((const char**)newtexture_xpm),5,true,stloc("New Texture"));
	tbtxtview->insertButton(QPixmap((const char**)newtexturefolder_xpm),1,true,stloc("New Texture-Folder"));
	tbtxtview->insertSeparator();
	tbtxtview->insertSeparator();

       	tbtxtview->insertButton(QPixmap((const char**)newpigment_xpm),6,MPigment,true,stloc("Edit/New Pigment/Pigmentobjects") );
	tbtxtview->insertButton(QPixmap((const char**)newnormal_xpm),7,MNormal,true,stloc("Edit/New Normal-Element"));
	tbtxtview->insertButton(QPixmap((const char**)newfinish_xpm),8,MFinish,true,stloc("Edit/New Finish"));
	tbtxtview->insertButton(QPixmap((const char**)newinterior_xpm),9,MInterior,true,stloc("Edit/New Interior"));

	tb[1]=addToolBar(mainbar);
	tb[2]=addToolBar(tbview);
	tb[3]=addToolBar(tbtxtview);

	connect(tbview,SIGNAL(clicked(int)),this,SLOT(setViewMode(int)));
	connect(tbtxtview,SIGNAL(clicked(int)),tview,SLOT(MenuItemSel(int)));
	connect(this,SIGNAL(viewMode(int)),viewwidget,SLOT(setViewMode(int)));
	connect(this,SIGNAL(projectionMode(int)),viewwidget,SLOT(setProjectionMode(int)));
	connect(this,SIGNAL(axeMode(int)),viewwidget,SLOT(setAxeMode(int)));
	connect(this,SIGNAL(render(int)),viewwidget,SLOT(startRendering(int)));
 	connect(this,SIGNAL(render(int)),viewwidget,SLOT(startRendering(int)));

	connect(worldtree,SIGNAL(setSelected(base*)),viewwidget,SLOT(setSelected(base*)));
}

void	MainWin::createRecentMenu()
{
	Preferences	prefs;
	int		i,t;

	i = prefs.numRecentFiles();

	Mopenrecent->clear();
     	
	for(t = 0;t < i;t++)
	{
		QString		qstr;

		qstr = prefs.recentFile(t);
		Mopenrecent->insertItem(qstr,t + 1000);
	}
}

void	MainWin::createMenu()
{
	Preferences	prefs;

	Mopenrecent = new MPopupMenu;
	CHECK_PTR(Mopenrecent);
	
	connect(Mopenrecent,SIGNAL(activated(int)),this,SLOT(openRecentClicked(int)));
	
	createRecentMenu();
	
	Mfile = new MPopupMenu;
	CHECK_PTR(Mfile);

	mid[0] = Mfile->insertItem(QPixmap((const char**)filenew_xpm),i18n("New"),this,SLOT(newClicked()),CTRL+Key_N);
	Mfile->insertSeparator();
	mid[1] = Mfile->insertItem(QPixmap((const char**)fileopen_xpm),klocale->translate("Open"),this,SLOT(openClicked()),CTRL+Key_O);

	mid[2] = Mfile->insertItem(klocale->translate("Open Recent"),Mopenrecent);

	Mfile->insertSeparator();
	mid[3] = Mfile->insertItem(QPixmap((const char**)filefloppy_xpm),i18n("Save"),this,SLOT(saveClicked()),CTRL+Key_S);
	mid[4] = Mfile->insertItem(klocale->translate("Save As"),this,SLOT(saveAsClicked()),0);
	Mfile->insertSeparator();
	mid[5] = Mfile->insertItem(klocale->translate("Dump"),this,SLOT(dumpClicked()),0);
	Mfile->insertSeparator();
	mid[7] = Mfile->insertItem(klocale->translate("Options"),this,SLOT(optionsClicked()),0);
	Mfile->insertSeparator();
	mid[6] = Mfile->insertItem(klocale->translate("Exit"),this,SLOT(quitClicked()),CTRL+Key_Q);


/*
	Medit = new MPopupMenu;
	CHECK_PTR(Medit);

	mid[50] = Medit->insertItem(klocale->translate("Copy"),this,SLOT(copyClicked()),0);
	mid[51] = Medit->insertItem(klocale->translate("Cut"),this,SLOT(cutClicked()),0);
	mid[52] = Medit->insertItem(klocale->translate("Paste"),this,SLOT(pasteClicked()),0);
	Medit->insertSeparator();
	mid[53] = Medit->insertItem(klocale->translate("Add AnimScript"),this,SLOT(addAnimClicked()),0);
	mid[54] = Medit->insertItem(klocale->translate("Delete AnimScript"),this,SLOT(delAnimClicked()),0);
	mid[55] = Medit->insertItem(klocale->translate("Edit AnimScript"),this,SLOT(editAnimClicked()),0);
*/

	Mobjects = new MPopupMenu;
	CHECK_PTR(Mobjects);

	mid[10] = Mobjects->insertItem(QPixmap((const char**)obj_xpm),klocale->translate("Add Object"),this,SLOT(addObjectClicked()),0);
	mid[11] = Mobjects->insertItem(QPixmap((const char**)csg_xpm),klocale->translate("Add CSG"),this,SLOT(addCSGClicked()),0);
	mid[12] = Mobjects->insertItem(QPixmap((const char**)blob_xpm),klocale->translate("Add Blob"),this,SLOT(addBlobClicked()),0);
	Mobjects->insertSeparator();
	mid[13] = Mobjects->insertItem(QPixmap((const char**)ref_xpm),klocale->translate("Add RefrenceObject"),this,SLOT(addRefClicked()),0);
	Mobjects->insertSeparator();
	mid[14] = Mobjects->insertItem(QPixmap((const char**)sphere_xpm),klocale->translate("Add Sphere"),this,SLOT(addSphereClicked()),0);
	mid[15] = Mobjects->insertItem(QPixmap((const char**)cylinder_xpm),klocale->translate("Add Cylinder"),this,SLOT(addCylinderClicked()),0);
	Mobjects->insertSeparator();
	mid[16] = Mobjects->insertItem(QPixmap((const char**)box_xpm),klocale->translate("Add Box"),this,SLOT(addBoxClicked()),0);
	mid[17] = Mobjects->insertItem(QPixmap((const char**)cone_xpm),klocale->translate("Add Cone"),this,SLOT(addConeClicked()),0);
	mid[18] = Mobjects->insertItem(QPixmap((const char**)torus_xpm),klocale->translate("Add Torus"),this,SLOT(addTorusClicked()),0);
	mid[22] = Mobjects->insertItem(QPixmap((const char**)heightfield_xpm),klocale->translate("Add Heightfield"),this,SLOT(addHeightfieldClicked()),0);
	mid[21] = Mobjects->insertItem(QPixmap((const char**)plane_xpm),klocale->translate("Add Plane"),this,SLOT(addPlaneClicked()),0);
	mid[27] = Mobjects->insertItem(QPixmap((const char**)text_xpm),klocale->translate("Add Text"),this,SLOT(addTextClicked()),0);
	Mobjects->insertSeparator();
#ifdef DEBUG
	mid[19] = Mobjects->insertItem(QPixmap((const char**)mesh_xpm),klocale->translate("Add Mesh"),this,SLOT(addMeshClicked()),0);
#endif
	mid[23] = Mobjects->insertItem(QPixmap((const char**)triangle_xpm),klocale->translate("Add Triangle"),this,SLOT(addTriangleClicked()),0);
	Mobjects->insertSeparator();
	mid[20] = Mobjects->insertItem(QPixmap((const char**)refptr_xpm),klocale->translate("Add Reference"),this,SLOT(addRefPtrClicked()),0);
	Mobjects->insertSeparator();
	mid[24] = Mobjects->insertItem(QPixmap((const char**)spotlight_xpm),klocale->translate("Add Spotlight"),this,SLOT(addSpotLightClicked()),0);
#ifdef DEBUG
	mid[25] = Mobjects->insertItem(QPixmap((const char**)arealight_xpm),klocale->translate("Add Arealight"),this,SLOT(addAreaLightClicked()),0);
#endif
	mid[26] = Mobjects->insertItem(QPixmap((const char**)lightpoint_xpm),klocale->translate("Add Lightpoint"),this,SLOT(addLightPointClicked()),0);
#ifdef DEBUG
	Mobjects->insertSeparator();
	mid[28] = Mobjects->insertItem(QPixmap((const char**)camera_xpm),klocale->translate("Add Camera"),this,SLOT(addCameraClicked()),0);
#endif

	Mpov = new MPopupMenu;
	CHECK_PTR(Mpov);

	mid[30] = Mpov->insertItem(QPixmap((const char**)filefloppy_xpm),klocale->translate("Export"),this,SLOT(exportPOVClicked()),0);
	Mpov->insertSeparator();
	mid[31] = Mpov->insertItem(QPixmap((const char**)filefloppy_xpm),klocale->translate("Export Texturelibrary"),this,SLOT(exportTLibClicked()),0);

	Mwindows = new MPopupMenu;
	CHECK_PTR(Mwindows);

	mid[40] = Mwindows->insertItem(klocale->translate("Animcontrol"),this,SLOT(toggleWACClicked()),0);
        Mwindows->insertSeparator();
	mid[60] = Mwindows->insertItem(klocale->translate("Main-Toolbar"),this,SLOT(toggleMainToolBar()),0);
	mid[61] = Mwindows->insertItem(klocale->translate("View-Toolbar"),this,SLOT(toggleViewToolBar()),0);
	mid[62] = Mwindows->insertItem(klocale->translate("Texture-Toolbar"),this,SLOT(toggleTextureToolBar()),0);

	

        Mwindows->setItemChecked(mid[40],0);
        Mwindows->setItemChecked(mid[60],1);
        Mwindows->setItemChecked(mid[61],1);
        Mwindows->setItemChecked(mid[62],1);

	Mhelp = new MPopupMenu;
	CHECK_PTR(Mhelp);

	extern KApplication	*k4deapp;

	QString str = PROGNAME" V" VERSION " (c) 1998, 1999, 2000 Markus Weber, Tobias Wollgam\n\n";
	str += "All sources underlay the GNU Public Licence. (read doc/COPYING)\n";
	str += "Commercialy use is prohibited!\n\n";
	str += "Please send all questions, comments and bugreports to:\n\n";
	str += "k4de@gmx.de or Tobias.Wollgam@gmx.de or mweber@gmx.de\n\n";
		       
	str += "K4DE-homepage: http://come.to/k4de\n\n";
		
	Mhelp = k4deapp->getHelpMenu(true, str.data());

	mainmenu = new KMenuBar(this,"mainmenu");
	CHECK_PTR(mainmenu);
	mainmenu->insertItem(klocale->translate("&File"),Mfile);
//	mainmenu->insertItem(klocale->translate("&Edit"),Medit);
	mainmenu->insertItem(klocale->translate("&Objects"),Mobjects);
	mainmenu->insertItem(klocale->translate("&PovRay"),Mpov);
//	mainmenu->insertItem(klocale->translate("&Options"),Moptions);
	mainmenu->insertItem(klocale->translate("&Windows"),Mwindows);
	mainmenu->insertSeparator();
	mainmenu->insertItem(klocale->translate("&Help"),Mhelp);


	setMenu(mainmenu);
}

void	MainWin::newClicked()
{
	if(changed)
	{
		QString		str;
		int		result;

		str = "k4de V" VERSION " \n\n";
		str += /*klocale->translate*/("The data has changed and is currently not saved!");
		KMsgBox	mb;
		result = mb.yesNoCancel(0,/*stloc*/("New world?"),str,8,/*stloc*/("Abort"),/*stloc*/("Save now"),/*stloc*/("Load"));
		if(result == 1) return;
		if(result == 2) saveClicked();
	}
	worldtree->empty();
	
	viewwidget->setName("Main View");
	
	changed = 0;
	
	if(projectname)
		free(projectname);
	projectname = 0;
	
	createWindowTitle();
	createStatusBar("New Projekt");
	displayMessage("New Projekt");
}

void	MainWin::quitClicked()
{
//	delete this;
	exit(0);
}

void	MainWin::openClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;
 	Preferences	prefs;
	
	if(changed)
	{
		QString		str;
		int		result;

		str = "k4de V" VERSION " \n\n";
		str += /*klocale->translate*/("The data has changed and is currently not saved!");
		KMsgBox	mb;
		result = mb.yesNoCancel(0,/*stloc*/("Load new file?"),str,8,/*stloc*/("Abort"),/*stloc*/("Save now"),/*stloc*/("Load"));
		if(result == 1) return;
		if(result == 2) saveClicked();
	}

	fd = new KFileDialog(0);

	qstr = fd->getOpenFileName(lastread,"*.3dds",this,0);

	if(qstr == "") return;

	strcpy(name,qstr.data());
	delete fd;

	lastread = qstr;
	if(lastread.findRev('/'))
		lastread.remove(lastread.findRev('/') + 1,lastread.length() - lastread.findRev('/'));

	if(worldtree->load(name) == 0)
	{
		qstr = projectname = strdup(name);

		changed = 0;
	
		prefs.setRecentFile(qstr);
		createRecentMenu();

		qstr = "Loaded " + qstr;		
		createStatusBar(qstr);
	}
	createWindowTitle();
}

void	MainWin::openRecentClicked(int id)
{
	QString		qstr;
	char		name[1024];
	Preferences	prefs;

	qstr = prefs.recentFile(id - 1000);

	// printf("ID = %i   File: %s   ",id,(char*)qstr.data());

	if(changed)
	{
		QString		str;
		int		result;

		str = "k4de V" VERSION " \n\n";
		str += /*klocale->translate*/("The data has changed and is currently not saved!");
		KMsgBox	mb;
		result = mb.yesNoCancel(0,/*stloc*/("Load new file?"),str,8,/*stloc*/("Abort"),/*stloc*/("Save now"),/*stloc*/("Load"));
		if(result == 1) return;
		if(result == 2) saveClicked();
	}

	if(qstr == "") return;

	strcpy(name,qstr.data());

	lastread = qstr;
	
	if(lastread.findRev('/'))
		lastread.remove(lastread.findRev('/') + 1,lastread.length() - lastread.findRev('/'));

	if(worldtree->load(name) == 0)
	{
		qstr = projectname = strdup(name);

		changed = 0;
	
		prefs.setRecentFile(qstr);
		createRecentMenu();
		
		qstr = "Loaded " + qstr;		
		createStatusBar(qstr);
	}
	createWindowTitle();
}

void	MainWin::saveClicked()
{
	if(worldtree->save(projectname) == 0)
	{
		QString		qstr;
			
		changed = 0;
		
		qstr = "Saved ";
		qstr += projectname;		
		createStatusBar(qstr);
	}
	else saveAsClicked();
	createWindowTitle();
}

void	MainWin::saveAsClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;
	
	fd = new KFileDialog(lastwrite);

	qstr = fd->getSaveFileName(lastwrite,"*.3dds",this,0);

	if(qstr == "") return;

	strcpy(name,qstr.data());
	delete fd;

	lastwrite = qstr;

	if(worldtree->save(name) == 0)
	{
		QString		qstr;
			
		projectname = strdup(name);
		changed = 0;
		
		qstr = "Saved ";
		qstr += projectname;		
		createStatusBar(qstr);
	}

	createWindowTitle();
}

void	MainWin::dumpClicked()
{
	worldtree->dump();
}

void	MainWin::optionsClicked()
{
	PreferencesDialog	*pd;

	pd = new PreferencesDialog(this);

	connect(pd,SIGNAL(update()),viewwidget,SLOT(reconfigure()));

	pd->show();

	delete pd;

	// why do the connect do nothing?
	viewwidget->reconfigure();
}

void	MainWin::exportPOVClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;

	fd = new KFileDialog(lastpov);

	qstr = fd->getSaveFileName(lastpov,"*.pov",this,0);

	if(qstr == "") return;

	strcpy(name,qstr.data());
	delete fd;

	lastpov = qstr;

	if(worldtree->exportPOV(name,viewwidget) == 0)
	{
	}
}

void	MainWin::exportPOV(const char *name)
{
	if(worldtree->exportPOV(name,viewwidget,0) == 0)
	{
	}
}

void	MainWin::exportPOVanim(const char *name)
{
	if(worldtree->exportPOV(name,viewwidget,1) == 0)
	{
	}
}

void	MainWin::addObjectClicked()
{
	worldtree->addObject();
}

void	MainWin::addCSGClicked()
{
	worldtree->addCSG();
}

void	MainWin::addBlobClicked()
{
	worldtree->addBlob();
}

void	MainWin::addRefClicked()
{
	worldtree->addRef();
}

void	MainWin::addSphereClicked()
{
	worldtree->addSphere();
}

void	MainWin::addCylinderClicked()
{
	worldtree->addCylinder();
}

void	MainWin::addBoxClicked()
{
	worldtree->addBox();
}

void	MainWin::addMeshClicked()
{
	worldtree->addMesh();
}

void	MainWin::addRefPtrClicked()
{
	worldtree->addRefPtr();
}

void	MainWin::addConeClicked()
{
	worldtree->addCone();
}

void	MainWin::addPlaneClicked()
{
	worldtree->addPlane();
}

void	MainWin::addTextClicked()
{
	worldtree->addText();
}

void	MainWin::addTorusClicked()
{
	worldtree->addTorus();
}

void	MainWin::addTriangleClicked()
{
	worldtree->addTriangle();
}

void	MainWin::addHeightfieldClicked()
{
	worldtree->addHeightfield();
}

void	MainWin::addLightPointClicked()
{
	worldtree->addLightPoint();
}

void	MainWin::addSpotLightClicked()
{
	worldtree->addSpotLight();
}

void	MainWin::addAreaLightClicked()
{
	worldtree->addAreaLight();
}

void	MainWin::addCameraClicked()
{
	worldtree->addCamera();
}

void 	MainWin::exportTLibClicked()
{
	tview->exportTLib();
}

void	MainWin::toggleWACClicked()
{
        if(!Mwindows->isItemChecked(mid[40]))
        {
        	animwidget->show();
        	tview->setMinimumSize(400,vpanner2->height() - animwidget->height() - 4);
        	Mwindows->setItemChecked(mid[40],!0);
		vpanner2->setAbsSeperatorPos(vpanner2->height() - animwidget->height());
        }
        else
        {
        	animwidget->hide();
        	tview->setMinimumSize(400,vpanner2->height() - 4);
        	Mwindows->setItemChecked(mid[40],0);
		vpanner2->setAbsSeperatorPos(vpanner2->height() - 10);
        }
}

void MainWin::toggleMainToolBar()
{
	if (!Mwindows->isItemChecked(mid[60])) {
		enableToolBar(KToolBar::Show,tb[1]);
        	Mwindows->setItemChecked(mid[60],!0);
	} else {
		enableToolBar(KToolBar::Hide,tb[1]);
        	Mwindows->setItemChecked(mid[60],0);
	}
}

void MainWin::toggleViewToolBar()
{
	if (!Mwindows->isItemChecked(mid[61])) {
		enableToolBar(KToolBar::Show,tb[2]);
        	Mwindows->setItemChecked(mid[61],!0);
	} else {
		enableToolBar(KToolBar::Hide,tb[2]);
        	Mwindows->setItemChecked(mid[61],0);
	}
}

void MainWin::toggleTextureToolBar()
{
	if (!Mwindows->isItemChecked(mid[62])) {
		enableToolBar(KToolBar::Show,tb[3]);
        	Mwindows->setItemChecked(mid[62],!0);
	} else {
		enableToolBar(KToolBar::Hide,tb[3]);
        	Mwindows->setItemChecked(mid[62],0);
	}
}



void	MainWin::paintEvent(QPaintEvent *pe)
{
	KTMainWindow::paintEvent(pe);
//	KTopLevelWidget::paintEvent(pe);
}

void	MainWin::show()
{
	KTMainWindow::show();
//	KTopLevelWidget::show();
	
	toggleWACClicked();
	toggleWACClicked();
}

void	MainWin::setViewMode(int buttonn)
{
	int	t;

	if(buttonn < 7)
	{
		for(t = 1;t < 7;t++)
			if(t != buttonn)
				tbview->setButton(t,false);

		tbview->setButton(buttonn,true);

		emit viewMode(buttonn);
	}
	else if(buttonn < 11)
	{
		for(t = 7;t < 11;t++)
			if(t != buttonn)
				tbview->setButton(t,false);

		tbview->setButton(buttonn,true);

		emit projectionMode(buttonn - 6);
	}
	else if(buttonn < 14)
	{
		int		mode;

		mode = 0;
		if(tbview->isButtonOn(11)) mode |= 1;
		if(tbview->isButtonOn(12)) mode |= 2;
		if(tbview->isButtonOn(13)) mode |= 4;

		emit axeMode(mode);
	}
	else if(buttonn < 15)
	{
		emit render(11);
	}
	else if(buttonn < 16)
	{
		emit render(1);
	}
}


