/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** vectorwidget.cpp
*/
#include "vectorwidget.h"
#include "vectorwidget.moc"

#include <klocale.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


VectorWidget::VectorWidget(QWidget *parent,char *name) :
	QGroupBox(parent,name)
{
	setTitle(name);		

	vector=Vector3(0,0,0);


	check=new QCheckBox("all equal",this);
	check->setChecked(false);

	xe=new SpinBox(this,"X");
	ye=new SpinBox(this,"Y");
	ze=new SpinBox(this,"Z");
	allequal=false;

	connect(xe,SIGNAL(changed()),this,SLOT(ValueChanged() ));
	connect(ye,SIGNAL(changed()),this,SLOT(ValueChanged() ));
	connect(ze,SIGNAL(changed()),this,SLOT(ValueChanged() ));
	connect(check,SIGNAL(clicked()),this,SLOT(CheckPressed() ));
	//connect(cl,SIGNAL(clicked()),this,SLOT(CheckPressed() ));

}



void VectorWidget::CheckPressed()
{
	switch(check->isChecked() ) {
		case true:
			xe->setLabel("");
			ye->setEnabled(false);
			ze->setEnabled(false);
			allequal=true;
			vector[1]=vector[0];
			vector[2]=vector[0];
		break;
		case false:
			xe->setLabel("X");
			ye->setEnabled(true);
			ze->setEnabled(true);
			ye->setValue(vector[1]);
			ze->setValue(vector[2]);
			allequal=false;
		break;
	}
}

void VectorWidget::ValueChanged()
{
	if (allequal==false) {
		vector[0]=xe->getValue();
		vector[1]=ye->getValue();
		vector[2]=ze->getValue();
	} else {
		vector[0]=xe->getValue();
		vector[1]=xe->getValue();
		vector[2]=xe->getValue();
	}
	emit changed();
}

VectorWidget::~VectorWidget()
{
	free(titlelabel);
}

void VectorWidget::setGeometry(int a,int b,int w,int h)
{
int y;
QSize qs1,qs2;

	y=15;
	xe->setGeometry(5,y,w-10,20);

	y+=25;
	ye->setGeometry(5,y,w-10,20);

	y+=25;
	ze->setGeometry(5,y,w-10,20);

	y+=25;
	qs2=check->sizeHint();
	check->setGeometry(5,y,qs2.width(),25);
	
	QWidget::setGeometry(a,b,w,h);
}

Vector3 VectorWidget::getVector()
{
	return vector;
}

void VectorWidget::setVector(Vector3 v)
{
	vector=v;
	xe->setValue((vector[0]+0.1)-0.1);
	ye->setValue((vector[1]+0.1)-0.1);
	ze->setValue((vector[2]+0.1)-0.1);
	emit changed();
}


