/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorentrywidget.cpp
*/
#include "colorentrywidget.moc"




ColorEntryWidget::ColorEntryWidget(QWidget *parent,colorEntry *c) :
	QWidget(parent,"ColorEntryDialog")
{

	co=c;

	name=new QLineEdit(this);
	name->setText(c->getName());
	nameLabel=new QLabel("Name:",this);
	
	qc.setRgb( (int)(c->getRed()*255.0), (int)(c->getGreen()*255.0), (int)(c->getBlue()*255.0) );

	transp=new PercentWidget(this,"Transparency",c->getTransparency() );
	filter=new PercentWidget(this,"Filter",c->getFilter() );
	
	range=new SpinBox(this,"Range",co->getRange());
	range->DownTopValue(0,1);



	okay=NULL;
	cancel=NULL;

	colorbt=new KColorButton(qc,this);	
	active=new QCheckBox("Active",this);
	active->setChecked(co->active() );

}

void ColorEntryWidget::getColorEntry()
{
	co->setTransparency(transp->getValue());
	qc=colorbt->color();
   	co->setRed((double)(qc.red()/255.0));
	co->setGreen((double)(qc.green()/255.0));
	co->setBlue((double)(qc.blue()/255.0));
	co->setName(name->text());
	co->setRange( range->getValue() );
	co->setActive( active->isChecked(),NULL);
	co->setFilter( filter->getValue() );
}

ColorEntryWidget::~ColorEntryWidget()
{
}

int ColorEntryWidget::width()
{
	return 280;
}
int ColorEntryWidget::height()
{
	return 125;
}

void ColorEntryWidget::paintEvent(QPaintEvent* qp)
{
	//int w=width();
	//int h=height();
	
	nameLabel->setGeometry(10,10,50,25);
	name->setGeometry(65,10,150,25);

	active->setGeometry(220,10,60,25);

	colorbt->setGeometry(10,40,40,60);	
	transp->setGeometry(55,40,200,25);
	filter->setGeometry(102,70,153,25);
	
	range->setGeometry(width()/2-55,100,110,25);


	QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

ColorEntryDialog::ColorEntryDialog(QWidget *parent,colorEntry *c) :
	QDialog(parent,"ColorEntryDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new ColorEntryWidget(this,c);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(pw->width(),pw->height()+30);
	setMinimumSize(pw->width(),pw->height()+40);
	setMaximumSize(pw->width(),pw->height()+40);
	
}

ColorEntryDialog::~ColorEntryDialog()
{
}


void ColorEntryDialog::cancelPressed()
{
	QDialog::done(0);
}

void ColorEntryDialog::okayPressed()
{
	pw->getColorEntry();
	QDialog::done(1);
}

void ColorEntryDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}