/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colormapdialog.h
*/
#ifndef __ColorMapWidget_H__
#define __ColorMapWidget_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>

#include <color.h>
#include "../../3d/textures/colormap.h"
#include <qcolor.h>
#include "../misc/spinbox.h"
#include "../widgets/percentwidget.h"
#include "colorentrywidget.h"
// #include "patternmodifierdialog.h"

class PatternModifierWidget;
class	TransformationsWidget;
class	TurbulenceWidget;
class TabWidget;

class ColorMapWidget : public QWidget
{
Q_OBJECT
protected:
	colorMap *co;

	TabWidget		*tab;

	TransformationsWidget 	*tw;
	TurbulenceWidget 	*tbw;
	PatternModifierWidget *pmd;

	QLineEdit		*line;
	QPushButton		*transformations,*turbulence,*add;
	QCheckBox		*active;
	QLabel			*n,*label4;

	list<ColorEntryWidget *>		colorwidget;
	list<QWidget *>		widgetlist;


public:

	ColorMapWidget(QWidget *p, colorMap *);
	~ColorMapWidget();
	void getColorMap();

protected:
	void	paintEvent(QPaintEvent*);
public slots:

	void transformationsPressed();
	void turbulencePressed();
	void addClicked();

};

//--------------------------------------------------------

class ColorMapDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	ColorMapWidget		*pw;

public:

	ColorMapDialog(QWidget *p, colorMap *);
	~ColorMapDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};




#endif
