/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** getfilewidget.cpp
*/
#include "getfilewidget.h"
#include "getfilewidget.moc"

#include <klocale.h>

#include <stdio.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


GetFileWidget::GetFileWidget(QWidget *parent,char *name,QString path,int x) :
	QWidget(parent,name)
{
	start = path;
	GetType = x;
	filenamelabel = new QLabel(this);
	filenamelabel->setAutoResize(true);
	filenamelabel->setText(name);

	filename = new QLineEdit(this);
	filename->setText(path);

	switch(GetType)
	{
		case 0:
			QToolTip::add(filename,"Enter a filename or drop a file here");
		break;
		case 1:
			QToolTip::add(filename,"Enter a filename or drop an imagefile here\n(only png or gif....sorry)");
		break;		
		case 2:
			QToolTip::add(filename,"Enter or drop a directory here");
		break;
	}

	FileDialogBt = new QPushButton(this);
	FileDialogBt->setAutoResize(true);
	FileDialogBt->setText("...");
	FileDialogBt->setToggleButton(false);
	QToolTip::add(FileDialogBt,"Pop up a Filedialog");
	
	clearfile = new QPushButton(this);
	clearfile->setAutoResize(true);
	clearfile->setText("clear");
	QToolTip::add(clearfile,"Clear filename");

	dnd = new KDNDDropZone(this, DndText);

	connect(FileDialogBt,SIGNAL(clicked()),this,SLOT(getFile()));
	connect(clearfile,SIGNAL(clicked()),this,SLOT(clearFile()));

	connect(dnd,SIGNAL(dropAction(KDNDDropZone *)),this,SLOT(dropped(KDNDDropZone *)));
}



GetFileWidget::~GetFileWidget()
{
}

void GetFileWidget::setGeometry(int a, int b,int c,int d)
{
int x,y,w,h,w1,w2;
QSize qs;

	qs=filenamelabel->sizeHint();

	w=c;
	h=d;
	x = 0;
	y = 0;
	h = 25;
	w1 = qs.width();
	filenamelabel->setGeometry(x,y,w1,h);

	x= x+w1+5;
	w2=w-w1-20-40-20;  //breite-labelBreite-getfileBreite-clearBreite-Abstnde	
	filename->setGeometry(x,y,w2,h);


	x = x+w2+5;
	w2 = 20;
	FileDialogBt->setGeometry(x,y,w2,h);

	x=x+20+5;
	w2 = 40;
	clearfile->setGeometry(x,y,w2,h);
	QWidget::setGeometry(a,b,c,d);
}

void	GetFileWidget::getFile()
{
	QString		qs;
	KFileDialog	*kfd;

	qs = filename->text();
	if(qs != "" && !qs.isEmpty() && !qs.isNull())
		start = qs;

	switch(GetType)
	{
		case 0:
			kfd = new KFileDialog(0);
			qs = kfd->getOpenFileName(start,"*.*",this,0);
			if (qs.isEmpty()==false) filename->setText(qs);

		break;
		case 1:
			kfd = new KFileDialog(0);
			qs = kfd->getOpenFileName(start,"*.png *.gif",this,0);
			if (qs.isEmpty()==false) filename->setText(qs);

		break;
		case 2:
			kfd= new KFileDialog(0);
			qs = kfd->getDirectory(start);
			if (qs.isEmpty()==false) filename->setText(qs);

		break;

	}
	//filename->setText(qs);
	emit changed();
}

void GetFileWidget::clearFile()
{
	filename->setText("");
}
QString GetFileWidget::getFilename()
{
	return (char *)filename->text();
}

QString GetFileWidget::getImageType()
{
	char buf[20];
	FILE *f;

	f = fopen(getFilename(),"r");
	if(f != 0)
	{ 
		fread(buf,1,20,f);
		fclose(f);
		if(strncmp(buf,"GIF",3) == 0)
		{
			return "gif";
		}
		if(strncmp(buf + 1,"PNG",3) == 0)
		{
			return "png";
		}
	}

	return "???";
}

void GetFileWidget::setFilename(QString n)
{
	filename->setText(n);
}

void GetFileWidget::dropped(KDNDDropZone *d)
{
	char	data[256];
	FILE	*f;
	
	printf("Dropped Data:%s\n",(char*)d->getData());	
	if(strncmp("file:",d->getData(),5) != 0)
	{
		QMessageBox qm("Error","At this time you can only drop files",QMessageBox::Warning, QMessageBox::Cancel,0,0);
		qm.exec();
	}
	else
	{
		strcpy(data,d->getData() + 5);
		data[strlen(d->getData() + 5)] = 0;

		f = fopen(data,"r");
		if(f != 0)
		{
			filename->setText(data);
			fclose(f);
		}
		else
		{
			QMessageBox qm("Error","The File could not be opened...\n(Maybe you dropped more as one file)",QMessageBox::Warning, QMessageBox::Cancel,0,0);
			qm.exec();
		}
	}
}



		
