/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** chunk.cpp
*/
#include <stdlib.h>
#include <string.h>

#include "chunk.h"

chunk::chunk()
{
	start = pos = -1;
	chfp = stdout;
	mptr = 0;
}

chunk::chunk(media *m)
{
	start = pos = -1;
	chfp = stdout;
	mptr = m;
}

void	chunk::setFile(FILE *fp)
{
	chfp = fp;
}


void	chunk::setMedia(media *m)
{
	mptr = m;
}

void	chunk::readChunk(char n[4],int &l)
{
	start = mptr->tell();
	mptr->read(n,4);
	mptr->read(&l,4);
}

void	chunk::rejectChunk()
{
	mptr->seek(start,SEEK_SET);
}

void	chunk::writeChunk(const char *cn)
{
	mptr->write(cn,4);
	pos = mptr->tell();
//	printf("get len at %i\n",pos);
	mptr->write("####",4);
}

void	chunk::writeChunkLen(int l)
{
//	printf("write len at %i\n",pos);
	mptr->seek(pos,SEEK_SET);
	mptr->write(&l,4);
	mptr->seek(0,SEEK_END);
}

void	chunk::writeChunkLen()
{
	int	cpos,l;

//	printf("write len at %i\n",pos);
	cpos = mptr->tell();
	l = cpos - pos - 4;
	mptr->seek(pos,SEEK_SET);
	mptr->write(&l,4);
	mptr->seek(0,SEEK_END);
}

int	chunk::getChunkLen(int l)
{
	return l + 8;
}

char    *chunk::readName()
{
	int     l;
	char    *cp;

	mptr->read(&l,4);
	if (l>0) {
		cp = (char*)malloc(l + 1);
		if(cp)
		{
			mptr->read(cp,l);
			cp[l] = 0;
		}
	} else return 0;

	return cp;
}

char    *chunk::readNameChunk()
{
	int     l;
	char    *cp = 0;
        char	chnk[4];

	mptr->read(chnk,4);
	if(strncmp(chnk,"NAME",4) == 0)
	{
		mptr->read(&l,4);
		if(l > 0)
		{
			cp = (char*)malloc(l + 1);
			if(cp)
			{
				mptr->read(cp,l);
				cp[l] = 0;
			}
		}
	}
	else
	{
		mptr->seek(-4,SEEK_CUR);
	}

	return cp;
}

double chunk::readDouble()
{
	double d;

	mptr->read(&d,sizeof(double));

	return d;
}

int chunk::readInt()
{
	int i;

	mptr->read(&i,sizeof(int));

	return i;
}

Vector3 chunk::readVector()
{
	Vector3		v;

	v[0] = readDouble();
	v[1] = readDouble();
	v[2] = readDouble();

	return v;
}

Vector3 chunk::readVector3()
{
	return readVector();
}

Vector2 chunk::readVector2()
{
	Vector2		v;

	v[0] = readDouble();
	v[1] = readDouble();

	return v;
}

Vector4 chunk::readVector4()
{
	Vector4		v;

	v[0] = readDouble();
	v[1] = readDouble();
	v[2] = readDouble();
	v[3] = readDouble();

	return v;
}

int	chunk::writeName(const char *n)
{
	int     l;

	if (!n) l=0;
	else l = strlen(n);
	mptr->write(&l,4);
	mptr->write(n,l);

	return 0;
}

int	chunk::writeNameChunk(const char *n)
{
	int     l;

	if(!n)
		return 0;
	
	l = strlen(n);
	mptr->write("NAME",4);
	mptr->write(&l,4);
	mptr->write(n,l);

	return 0;
}

int	chunk::writeDouble(double d)
{
	mptr->write(&d,sizeof(double));

	return 0;
}

int	chunk::writeInt(int i)
{
	mptr->write(&i,sizeof(int));

	return 0;
}

int	chunk::writeVector(Vector3 v)
{
	writeDouble(v[0]);
	writeDouble(v[1]);
	writeDouble(v[2]);

	return 0;
}

int	chunk::writeVector(Vector2 v)
{
	writeDouble(v[0]);
	writeDouble(v[1]);

	return 0;
}

int	chunk::writeVector(Vector4 v)
{
	writeDouble(v[0]);
	writeDouble(v[1]);
	writeDouble(v[2]);
	writeDouble(v[3]);

	return 0;
}



