/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** box.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "box.h"
#include "num.h"
#include "view.h"



box::box(base *p,const char *n,texture *t) :
	csgobj(p,n,t)
{
	numtype = NUM_BOX;

	if(parent) addToParent(parent);
}

box::box(base *p,const char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,vs,vr,vt)
{
	numtype = NUM_BOX;

	if(parent)  addToParent(parent);
}

box::box(base *p,const char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,t,vs,vr,vt)
{
	numtype = NUM_BOX;

	if(parent)  addToParent(parent);
}

box::box(base *p,box *bc) : 
	csgobj(p,bc)
{
	numtype = NUM_BOX;

	if(parent)  addToParent(parent);
}

box::~box()
{
	// workaround
	removeFromParent();
}

int	box::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	box::removeFromParent() 
{ 
	if(!parent) return -2; 
 
	return parent->removeChild(this); 
} 

base	*box::copy(base *p)
{
	return new box(p,this);
}
 
base	*box::searchName(const char *n)
{
	if(n == 0)
		return 0;

	if(name != 0 && strcmp(name,n) == 0)
		return this;

	return 0;
}

void	box::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("box: %s\n",name);
}

int	box::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = box\n");
	printTab(fp,tab);
	fprintf(fp,"box\n");

	printTab(fp,tab); 
	fprintf(fp,"{\n");
 	printTab(fp,tab + tabsize);
	fprintf(fp,"<0.5,0.5,0.5>, <-0.5,-0.5,-0.5>\n");

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize,anim);

	transform::exportPOV(fp,tab + tabsize,tabsize,anim);

	if(isFlag(HOLLOW_ON))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow on\n");
	}
	else if(isFlag(HOLLOW_OFF))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow off\n");
	}
	
	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}


int	box::save(media *m,int ver)
{
	if(!m) return -1;

	switch(ver)
	{
		case 0:
		case -1:
			setMedia(m);
			writeChunk("BOX ");
			writeNameChunk(name);
			saveFlags(m);
			anim::save(m);
			transform::save(m,ver);
			saveTexture(m);
			writeChunkLen();
		break;
		default:
			return -2;
	}

	return 0;
}

int	box::load(media *m,int l,int ver)
{
	int	pos = m->tell();

	switch(ver)
	{
		case 0:
		case -1:
			loadFlags(m,l);
			anim::load(m,l - (m->tell() - pos));
			transform::load(m,l - (m->tell() - pos),ver);
			if(l > m->tell() - pos)
			{
				loadTexture(m,l - (m->tell() - pos));
			}
		break;
		default:
			return -2;
	}

	return 0;
}

int	box::draw(view *v,Matrix44 m,int anim)
{
	Vector3	p,vx,vy,vz;

	//printf("Box\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(0.5,0,0);
	vy = Vector3(0,0.5,0);
	vz = Vector3(0,0,0.5);

	transformMatrix(m,anim);

	if(this == v->getSelected()) v->setDrawSelected(1);

	if(isFlag(DRAW_BOUNDINGBOX))
		drawBB(v,m,anim);
	else
		v->drawBox(p,vx,vy,vz,m,anim);

	if(this == v->getSelected()) v->setDrawSelected(0);

	if(isFlag(DRAW_AXIS))
		v->drawAxis(m,anim);

	drawDragvectors(v,m,anim);

	return 0;
}

int	box::calculate(int)
{
	setMin(Vector3(-0.5,-0.5,-0.5));
	setMax(Vector3(0.5,0.5,0.5));

	return 0;
}

double	box::volume(int anim)
{
	Vector3	v;

	v = getVScale();

	return (v[0] * v[1] * v[2]);
}





