/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** gmesh.h
*/

#ifndef __GMESH_H__
#define __GMESH_H__

#include <list.h>
#include <matmath.h>


class gmesh;

class gnode
{
protected:
	gmesh		*parent;
	list<gnode*>	nodelist;
	int		state;
	Vector3		v;

public:
	gnode(Vector3 v);
	gnode(gmesh*,Vector3 v);
//	gnode(gmesh*,gnode*);
	~gnode();

	Vector3		vector();
	void		setVector(Vector3);

	int		addNode(gnode*);
	gnode		*getNode(int i);
	int		removeNode(gnode*);

	void		setState(int s=0);
	int		getState();


private:
//	int		distance(gnode*);

friend class gmesh;
};


class gmesh
{
protected:
	list<gnode*>	nodelist;

public:
	gmesh();
	~gmesh();

	int		addNode(gnode*);
	int		removeNode(gnode*);
	gnode		*getNode(int);

	int		numNodes();

	gnode		*findNode(Vector3);

//	int		distance(gnode*,gnode*);

//	int		removeDoubleNodes();

protected:
	void		sortNodes();
	int		insortNode(gnode *n);
	
private:
	int		sf(gnode*,gnode*);
		
friend class gnode;
};

#endif



